package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{UUId, InstanceArn}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAssignmentCreationStatusRequest(
    instanceArn: InstanceArn,
    accountAssignmentCreationRequestId: UUId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest = {
    import DescribeAccountAssignmentCreationStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .accountAssignmentCreationRequestId(
        UUId.unwrap(accountAssignmentCreationRequestId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest.ReadOnly =
    zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
      .wrap(buildAwsValue())
}
object DescribeAccountAssignmentCreationStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest =
      zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest(
        instanceArn,
        accountAssignmentCreationRequestId
      )
    def instanceArn: InstanceArn
    def accountAssignmentCreationRequestId: UUId
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getAccountAssignmentCreationRequestId: ZIO[Any, Nothing, UUId] =
      ZIO.succeed(accountAssignmentCreationRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
  ) extends zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val accountAssignmentCreationRequestId: UUId =
      zio.aws.ssoadmin.model.primitives
        .UUId(impl.accountAssignmentCreationRequestId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
  ): zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest.ReadOnly =
    new Wrapper(impl)
}
