package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{UUId, InstanceArn}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAssignmentDeletionStatusRequest(
    instanceArn: InstanceArn,
    accountAssignmentDeletionRequestId: UUId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest = {
    import DescribeAccountAssignmentDeletionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .accountAssignmentDeletionRequestId(
        UUId.unwrap(accountAssignmentDeletionRequestId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest.ReadOnly =
    zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
      .wrap(buildAwsValue())
}
object DescribeAccountAssignmentDeletionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest =
      zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest(
        instanceArn,
        accountAssignmentDeletionRequestId
      )
    def instanceArn: InstanceArn
    def accountAssignmentDeletionRequestId: UUId
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getAccountAssignmentDeletionRequestId: ZIO[Any, Nothing, UUId] =
      ZIO.succeed(accountAssignmentDeletionRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
  ) extends zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val accountAssignmentDeletionRequestId: UUId =
      zio.aws.ssoadmin.model.primitives
        .UUId(impl.accountAssignmentDeletionRequestId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
  ): zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
