package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.InstanceArn
import scala.jdk.CollectionConverters.*
final case class DescribeInstanceAccessControlAttributeConfigurationRequest(
    instanceArn: InstanceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest = {
    import DescribeInstanceAccessControlAttributeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest.ReadOnly =
    zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeInstanceAccessControlAttributeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest =
      zio.aws.ssoadmin.model
        .DescribeInstanceAccessControlAttributeConfigurationRequest(instanceArn)
    def instanceArn: InstanceArn
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest
  ) extends zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest
  ): zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
