package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAccountAssignmentsResponse(
    accountAssignments: Optional[
      Iterable[zio.aws.ssoadmin.model.AccountAssignment]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse = {
    import ListAccountAssignmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse
      .builder()
      .optionallyWith(
        accountAssignments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountAssignments)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.wrap(buildAwsValue())
}
object ListAccountAssignmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListAccountAssignmentsResponse =
      zio.aws.ssoadmin.model.ListAccountAssignmentsResponse(
        accountAssignments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountAssignments
        : Optional[List[zio.aws.ssoadmin.model.AccountAssignment.ReadOnly]]
    def nextToken: Optional[Token]
    def getAccountAssignments: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.AccountAssignment.ReadOnly
    ]] = AwsError.unwrapOptionField("accountAssignments", accountAssignments)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse
  ) extends zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.ReadOnly {
    override val accountAssignments
        : Optional[List[zio.aws.ssoadmin.model.AccountAssignment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountAssignments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssoadmin.model.AccountAssignment.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse
  ): zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.ReadOnly =
    new Wrapper(impl)
}
