package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{Token, AccountId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAccountsForProvisionedPermissionSetResponse(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse = {
    import ListAccountsForProvisionedPermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse
      .wrap(buildAwsValue())
}
object ListAccountsForProvisionedPermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse =
      zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse(
        accountIds.map(value => value),
        nextToken.map(value => value)
      )
    def accountIds: Optional[List[AccountId]]
    def nextToken: Optional[Token]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse
  ) extends zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.primitives.AccountId(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse
  ): zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
