package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.ManagedPolicyArn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PermissionsBoundary(
    customerManagedPolicyReference: Optional[
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference
    ] = Optional.Absent,
    managedPolicyArn: Optional[ManagedPolicyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.PermissionsBoundary = {
    import PermissionsBoundary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.PermissionsBoundary
      .builder()
      .optionallyWith(
        customerManagedPolicyReference.map(value => value.buildAwsValue())
      )(_.customerManagedPolicyReference)
      .optionallyWith(
        managedPolicyArn.map(value =>
          ManagedPolicyArn.unwrap(value): java.lang.String
        )
      )(_.managedPolicyArn)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly =
    zio.aws.ssoadmin.model.PermissionsBoundary.wrap(buildAwsValue())
}
object PermissionsBoundary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.PermissionsBoundary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.PermissionsBoundary =
      zio.aws.ssoadmin.model.PermissionsBoundary(
        customerManagedPolicyReference.map(value => value.asEditable),
        managedPolicyArn.map(value => value)
      )
    def customerManagedPolicyReference: Optional[
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    ]
    def managedPolicyArn: Optional[ManagedPolicyArn]
    def getCustomerManagedPolicyReference: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customerManagedPolicyReference",
      customerManagedPolicyReference
    )
    def getManagedPolicyArn: ZIO[Any, AwsError, ManagedPolicyArn] =
      AwsError.unwrapOptionField("managedPolicyArn", managedPolicyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionsBoundary
  ) extends zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly {
    override val customerManagedPolicyReference: Optional[
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerManagedPolicyReference())
      .map(value =>
        zio.aws.ssoadmin.model.CustomerManagedPolicyReference.wrap(value)
      )
    override val managedPolicyArn: Optional[ManagedPolicyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedPolicyArn())
        .map(value => zio.aws.ssoadmin.model.primitives.ManagedPolicyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionsBoundary
  ): zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly = new Wrapper(impl)
}
