package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.ssoadmin.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.Tag.ReadOnly =
    zio.aws.ssoadmin.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssoadmin.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.Tag =
      zio.aws.ssoadmin.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.Tag
  ) extends zio.aws.ssoadmin.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.ssoadmin.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.ssoadmin.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.Tag
  ): zio.aws.ssoadmin.model.Tag.ReadOnly = new Wrapper(impl)
}
