package zio.aws.ssooidc.model
import zio.aws.ssooidc.model.primitives.{
  URI,
  LongTimeStampType,
  ClientSecret,
  ClientId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterClientResponse(
    clientId: Optional[ClientId] = Optional.Absent,
    clientSecret: Optional[ClientSecret] = Optional.Absent,
    clientIdIssuedAt: Optional[LongTimeStampType] = Optional.Absent,
    clientSecretExpiresAt: Optional[LongTimeStampType] = Optional.Absent,
    authorizationEndpoint: Optional[URI] = Optional.Absent,
    tokenEndpoint: Optional[URI] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse = {
    import RegisterClientResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse
      .builder()
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        clientSecret.map(value => ClientSecret.unwrap(value): java.lang.String)
      )(_.clientSecret)
      .optionallyWith(
        clientIdIssuedAt.map(value =>
          LongTimeStampType.unwrap(value): java.lang.Long
        )
      )(_.clientIdIssuedAt)
      .optionallyWith(
        clientSecretExpiresAt.map(value =>
          LongTimeStampType.unwrap(value): java.lang.Long
        )
      )(_.clientSecretExpiresAt)
      .optionallyWith(
        authorizationEndpoint.map(value => URI.unwrap(value): java.lang.String)
      )(_.authorizationEndpoint)
      .optionallyWith(
        tokenEndpoint.map(value => URI.unwrap(value): java.lang.String)
      )(_.tokenEndpoint)
      .build()
  }
  def asReadOnly: zio.aws.ssooidc.model.RegisterClientResponse.ReadOnly =
    zio.aws.ssooidc.model.RegisterClientResponse.wrap(buildAwsValue())
}
object RegisterClientResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.RegisterClientResponse =
      zio.aws.ssooidc.model.RegisterClientResponse(
        clientId.map(value => value),
        clientSecret.map(value => value),
        clientIdIssuedAt.map(value => value),
        clientSecretExpiresAt.map(value => value),
        authorizationEndpoint.map(value => value),
        tokenEndpoint.map(value => value)
      )
    def clientId: Optional[ClientId]
    def clientSecret: Optional[ClientSecret]
    def clientIdIssuedAt: Optional[LongTimeStampType]
    def clientSecretExpiresAt: Optional[LongTimeStampType]
    def authorizationEndpoint: Optional[URI]
    def tokenEndpoint: Optional[URI]
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getClientSecret: ZIO[Any, AwsError, ClientSecret] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
    def getClientIdIssuedAt: ZIO[Any, AwsError, LongTimeStampType] =
      AwsError.unwrapOptionField("clientIdIssuedAt", clientIdIssuedAt)
    def getClientSecretExpiresAt: ZIO[Any, AwsError, LongTimeStampType] =
      AwsError.unwrapOptionField("clientSecretExpiresAt", clientSecretExpiresAt)
    def getAuthorizationEndpoint: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("authorizationEndpoint", authorizationEndpoint)
    def getTokenEndpoint: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("tokenEndpoint", tokenEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse
  ) extends zio.aws.ssooidc.model.RegisterClientResponse.ReadOnly {
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.ssooidc.model.primitives.ClientId(value))
    override val clientSecret: Optional[ClientSecret] = zio.aws.core.internal
      .optionalFromNullable(impl.clientSecret())
      .map(value => zio.aws.ssooidc.model.primitives.ClientSecret(value))
    override val clientIdIssuedAt: Optional[LongTimeStampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientIdIssuedAt())
        .map(value => zio.aws.ssooidc.model.primitives.LongTimeStampType(value))
    override val clientSecretExpiresAt: Optional[LongTimeStampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientSecretExpiresAt())
        .map(value => zio.aws.ssooidc.model.primitives.LongTimeStampType(value))
    override val authorizationEndpoint: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizationEndpoint())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
    override val tokenEndpoint: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenEndpoint())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse
  ): zio.aws.ssooidc.model.RegisterClientResponse.ReadOnly = new Wrapper(impl)
}
