package zio.aws.ssooidc.model
import zio.aws.ssooidc.model.primitives.{
  GrantType,
  RefreshToken,
  ClientSecret,
  ClientId,
  AuthCode,
  Scope,
  URI,
  DeviceCode,
  CodeVerifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTokenRequest(
    clientId: ClientId,
    clientSecret: ClientSecret,
    grantType: GrantType,
    deviceCode: Optional[DeviceCode] = Optional.Absent,
    code: Optional[AuthCode] = Optional.Absent,
    refreshToken: Optional[RefreshToken] = Optional.Absent,
    scope: Optional[Iterable[Scope]] = Optional.Absent,
    redirectUri: Optional[URI] = Optional.Absent,
    codeVerifier: Optional[CodeVerifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest = {
    import CreateTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest
      .builder()
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .clientSecret(ClientSecret.unwrap(clientSecret): java.lang.String)
      .grantType(GrantType.unwrap(grantType): java.lang.String)
      .optionallyWith(
        deviceCode.map(value => DeviceCode.unwrap(value): java.lang.String)
      )(_.deviceCode)
      .optionallyWith(
        code.map(value => AuthCode.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        refreshToken.map(value => RefreshToken.unwrap(value): java.lang.String)
      )(_.refreshToken)
      .optionallyWith(
        scope.map(value =>
          value.map { item =>
            Scope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scope)
      .optionallyWith(
        redirectUri.map(value => URI.unwrap(value): java.lang.String)
      )(_.redirectUri)
      .optionallyWith(
        codeVerifier.map(value => CodeVerifier.unwrap(value): java.lang.String)
      )(_.codeVerifier)
      .build()
  }
  def asReadOnly: zio.aws.ssooidc.model.CreateTokenRequest.ReadOnly =
    zio.aws.ssooidc.model.CreateTokenRequest.wrap(buildAwsValue())
}
object CreateTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.CreateTokenRequest =
      zio.aws.ssooidc.model.CreateTokenRequest(
        clientId,
        clientSecret,
        grantType,
        deviceCode.map(value => value),
        code.map(value => value),
        refreshToken.map(value => value),
        scope.map(value => value),
        redirectUri.map(value => value),
        codeVerifier.map(value => value)
      )
    def clientId: ClientId
    def clientSecret: ClientSecret
    def grantType: GrantType
    def deviceCode: Optional[DeviceCode]
    def code: Optional[AuthCode]
    def refreshToken: Optional[RefreshToken]
    def scope: Optional[List[Scope]]
    def redirectUri: Optional[URI]
    def codeVerifier: Optional[CodeVerifier]
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
    def getClientSecret: ZIO[Any, Nothing, ClientSecret] =
      ZIO.succeed(clientSecret)
    def getGrantType: ZIO[Any, Nothing, GrantType] = ZIO.succeed(grantType)
    def getDeviceCode: ZIO[Any, AwsError, DeviceCode] =
      AwsError.unwrapOptionField("deviceCode", deviceCode)
    def getCode: ZIO[Any, AwsError, AuthCode] =
      AwsError.unwrapOptionField("code", code)
    def getRefreshToken: ZIO[Any, AwsError, RefreshToken] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getScope: ZIO[Any, AwsError, List[Scope]] =
      AwsError.unwrapOptionField("scope", scope)
    def getRedirectUri: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("redirectUri", redirectUri)
    def getCodeVerifier: ZIO[Any, AwsError, CodeVerifier] =
      AwsError.unwrapOptionField("codeVerifier", codeVerifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest
  ) extends zio.aws.ssooidc.model.CreateTokenRequest.ReadOnly {
    override val clientId: ClientId =
      zio.aws.ssooidc.model.primitives.ClientId(impl.clientId())
    override val clientSecret: ClientSecret =
      zio.aws.ssooidc.model.primitives.ClientSecret(impl.clientSecret())
    override val grantType: GrantType =
      zio.aws.ssooidc.model.primitives.GrantType(impl.grantType())
    override val deviceCode: Optional[DeviceCode] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceCode())
      .map(value => zio.aws.ssooidc.model.primitives.DeviceCode(value))
    override val code: Optional[AuthCode] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.ssooidc.model.primitives.AuthCode(value))
    override val refreshToken: Optional[RefreshToken] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshToken())
      .map(value => zio.aws.ssooidc.model.primitives.RefreshToken(value))
    override val scope: Optional[List[Scope]] = zio.aws.core.internal
      .optionalFromNullable(impl.scope())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssooidc.model.primitives.Scope(item)
        }.toList
      )
    override val redirectUri: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectUri())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
    override val codeVerifier: Optional[CodeVerifier] = zio.aws.core.internal
      .optionalFromNullable(impl.codeVerifier())
      .map(value => zio.aws.ssooidc.model.primitives.CodeVerifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest
  ): zio.aws.ssooidc.model.CreateTokenRequest.ReadOnly = new Wrapper(impl)
}
