package zio.aws.ssooidc.model
import zio.aws.ssooidc.model.primitives.{
  GrantType,
  SubjectToken,
  Assertion,
  TokenTypeURI,
  RefreshToken,
  ClientId,
  AuthCode,
  Scope,
  URI,
  CodeVerifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTokenWithIamRequest(
    clientId: ClientId,
    grantType: GrantType,
    code: Optional[AuthCode] = Optional.Absent,
    refreshToken: Optional[RefreshToken] = Optional.Absent,
    assertion: Optional[Assertion] = Optional.Absent,
    scope: Optional[Iterable[Scope]] = Optional.Absent,
    redirectUri: Optional[URI] = Optional.Absent,
    subjectToken: Optional[SubjectToken] = Optional.Absent,
    subjectTokenType: Optional[TokenTypeURI] = Optional.Absent,
    requestedTokenType: Optional[TokenTypeURI] = Optional.Absent,
    codeVerifier: Optional[CodeVerifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamRequest = {
    import CreateTokenWithIamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamRequest
      .builder()
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .grantType(GrantType.unwrap(grantType): java.lang.String)
      .optionallyWith(
        code.map(value => AuthCode.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        refreshToken.map(value => RefreshToken.unwrap(value): java.lang.String)
      )(_.refreshToken)
      .optionallyWith(
        assertion.map(value => Assertion.unwrap(value): java.lang.String)
      )(_.assertion)
      .optionallyWith(
        scope.map(value =>
          value.map { item =>
            Scope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scope)
      .optionallyWith(
        redirectUri.map(value => URI.unwrap(value): java.lang.String)
      )(_.redirectUri)
      .optionallyWith(
        subjectToken.map(value => SubjectToken.unwrap(value): java.lang.String)
      )(_.subjectToken)
      .optionallyWith(
        subjectTokenType.map(value =>
          TokenTypeURI.unwrap(value): java.lang.String
        )
      )(_.subjectTokenType)
      .optionallyWith(
        requestedTokenType.map(value =>
          TokenTypeURI.unwrap(value): java.lang.String
        )
      )(_.requestedTokenType)
      .optionallyWith(
        codeVerifier.map(value => CodeVerifier.unwrap(value): java.lang.String)
      )(_.codeVerifier)
      .build()
  }
  def asReadOnly: zio.aws.ssooidc.model.CreateTokenWithIamRequest.ReadOnly =
    zio.aws.ssooidc.model.CreateTokenWithIamRequest.wrap(buildAwsValue())
}
object CreateTokenWithIamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.CreateTokenWithIamRequest =
      zio.aws.ssooidc.model.CreateTokenWithIamRequest(
        clientId,
        grantType,
        code.map(value => value),
        refreshToken.map(value => value),
        assertion.map(value => value),
        scope.map(value => value),
        redirectUri.map(value => value),
        subjectToken.map(value => value),
        subjectTokenType.map(value => value),
        requestedTokenType.map(value => value),
        codeVerifier.map(value => value)
      )
    def clientId: ClientId
    def grantType: GrantType
    def code: Optional[AuthCode]
    def refreshToken: Optional[RefreshToken]
    def assertion: Optional[Assertion]
    def scope: Optional[List[Scope]]
    def redirectUri: Optional[URI]
    def subjectToken: Optional[SubjectToken]
    def subjectTokenType: Optional[TokenTypeURI]
    def requestedTokenType: Optional[TokenTypeURI]
    def codeVerifier: Optional[CodeVerifier]
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
    def getGrantType: ZIO[Any, Nothing, GrantType] = ZIO.succeed(grantType)
    def getCode: ZIO[Any, AwsError, AuthCode] =
      AwsError.unwrapOptionField("code", code)
    def getRefreshToken: ZIO[Any, AwsError, RefreshToken] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getAssertion: ZIO[Any, AwsError, Assertion] =
      AwsError.unwrapOptionField("assertion", assertion)
    def getScope: ZIO[Any, AwsError, List[Scope]] =
      AwsError.unwrapOptionField("scope", scope)
    def getRedirectUri: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("redirectUri", redirectUri)
    def getSubjectToken: ZIO[Any, AwsError, SubjectToken] =
      AwsError.unwrapOptionField("subjectToken", subjectToken)
    def getSubjectTokenType: ZIO[Any, AwsError, TokenTypeURI] =
      AwsError.unwrapOptionField("subjectTokenType", subjectTokenType)
    def getRequestedTokenType: ZIO[Any, AwsError, TokenTypeURI] =
      AwsError.unwrapOptionField("requestedTokenType", requestedTokenType)
    def getCodeVerifier: ZIO[Any, AwsError, CodeVerifier] =
      AwsError.unwrapOptionField("codeVerifier", codeVerifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamRequest
  ) extends zio.aws.ssooidc.model.CreateTokenWithIamRequest.ReadOnly {
    override val clientId: ClientId =
      zio.aws.ssooidc.model.primitives.ClientId(impl.clientId())
    override val grantType: GrantType =
      zio.aws.ssooidc.model.primitives.GrantType(impl.grantType())
    override val code: Optional[AuthCode] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.ssooidc.model.primitives.AuthCode(value))
    override val refreshToken: Optional[RefreshToken] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshToken())
      .map(value => zio.aws.ssooidc.model.primitives.RefreshToken(value))
    override val assertion: Optional[Assertion] = zio.aws.core.internal
      .optionalFromNullable(impl.assertion())
      .map(value => zio.aws.ssooidc.model.primitives.Assertion(value))
    override val scope: Optional[List[Scope]] = zio.aws.core.internal
      .optionalFromNullable(impl.scope())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssooidc.model.primitives.Scope(item)
        }.toList
      )
    override val redirectUri: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectUri())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
    override val subjectToken: Optional[SubjectToken] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectToken())
      .map(value => zio.aws.ssooidc.model.primitives.SubjectToken(value))
    override val subjectTokenType: Optional[TokenTypeURI] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subjectTokenType())
        .map(value => zio.aws.ssooidc.model.primitives.TokenTypeURI(value))
    override val requestedTokenType: Optional[TokenTypeURI] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestedTokenType())
        .map(value => zio.aws.ssooidc.model.primitives.TokenTypeURI(value))
    override val codeVerifier: Optional[CodeVerifier] = zio.aws.core.internal
      .optionalFromNullable(impl.codeVerifier())
      .map(value => zio.aws.ssooidc.model.primitives.CodeVerifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamRequest
  ): zio.aws.ssooidc.model.CreateTokenWithIamRequest.ReadOnly = new Wrapper(
    impl
  )
}
