package zio.aws.ssooidc.model
import zio.aws.ssooidc.model.primitives.{
  GrantType,
  ArnType,
  ClientType,
  ClientName,
  Scope,
  URI
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterClientRequest(
    clientName: ClientName,
    clientType: ClientType,
    scopes: Optional[Iterable[Scope]] = Optional.Absent,
    redirectUris: Optional[Iterable[URI]] = Optional.Absent,
    grantTypes: Optional[Iterable[GrantType]] = Optional.Absent,
    issuerUrl: Optional[URI] = Optional.Absent,
    entitledApplicationArn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest = {
    import RegisterClientRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest
      .builder()
      .clientName(ClientName.unwrap(clientName): java.lang.String)
      .clientType(ClientType.unwrap(clientType): java.lang.String)
      .optionallyWith(
        scopes.map(value =>
          value.map { item =>
            Scope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scopes)
      .optionallyWith(
        redirectUris.map(value =>
          value.map { item =>
            URI.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.redirectUris)
      .optionallyWith(
        grantTypes.map(value =>
          value.map { item =>
            GrantType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTypes)
      .optionallyWith(
        issuerUrl.map(value => URI.unwrap(value): java.lang.String)
      )(_.issuerUrl)
      .optionallyWith(
        entitledApplicationArn.map(value =>
          ArnType.unwrap(value): java.lang.String
        )
      )(_.entitledApplicationArn)
      .build()
  }
  def asReadOnly: zio.aws.ssooidc.model.RegisterClientRequest.ReadOnly =
    zio.aws.ssooidc.model.RegisterClientRequest.wrap(buildAwsValue())
}
object RegisterClientRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.RegisterClientRequest =
      zio.aws.ssooidc.model.RegisterClientRequest(
        clientName,
        clientType,
        scopes.map(value => value),
        redirectUris.map(value => value),
        grantTypes.map(value => value),
        issuerUrl.map(value => value),
        entitledApplicationArn.map(value => value)
      )
    def clientName: ClientName
    def clientType: ClientType
    def scopes: Optional[List[Scope]]
    def redirectUris: Optional[List[URI]]
    def grantTypes: Optional[List[GrantType]]
    def issuerUrl: Optional[URI]
    def entitledApplicationArn: Optional[ArnType]
    def getClientName: ZIO[Any, Nothing, ClientName] = ZIO.succeed(clientName)
    def getClientType: ZIO[Any, Nothing, ClientType] = ZIO.succeed(clientType)
    def getScopes: ZIO[Any, AwsError, List[Scope]] =
      AwsError.unwrapOptionField("scopes", scopes)
    def getRedirectUris: ZIO[Any, AwsError, List[URI]] =
      AwsError.unwrapOptionField("redirectUris", redirectUris)
    def getGrantTypes: ZIO[Any, AwsError, List[GrantType]] =
      AwsError.unwrapOptionField("grantTypes", grantTypes)
    def getIssuerUrl: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("issuerUrl", issuerUrl)
    def getEntitledApplicationArn: ZIO[Any, AwsError, ArnType] = AwsError
      .unwrapOptionField("entitledApplicationArn", entitledApplicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest
  ) extends zio.aws.ssooidc.model.RegisterClientRequest.ReadOnly {
    override val clientName: ClientName =
      zio.aws.ssooidc.model.primitives.ClientName(impl.clientName())
    override val clientType: ClientType =
      zio.aws.ssooidc.model.primitives.ClientType(impl.clientType())
    override val scopes: Optional[List[Scope]] = zio.aws.core.internal
      .optionalFromNullable(impl.scopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssooidc.model.primitives.Scope(item)
        }.toList
      )
    override val redirectUris: Optional[List[URI]] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectUris())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssooidc.model.primitives.URI(item)
        }.toList
      )
    override val grantTypes: Optional[List[GrantType]] = zio.aws.core.internal
      .optionalFromNullable(impl.grantTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssooidc.model.primitives.GrantType(item)
        }.toList
      )
    override val issuerUrl: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.issuerUrl())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
    override val entitledApplicationArn: Optional[ArnType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entitledApplicationArn())
        .map(value => zio.aws.ssooidc.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest
  ): zio.aws.ssooidc.model.RegisterClientRequest.ReadOnly = new Wrapper(impl)
}
