package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.{SourceIdentityType, NonNegativeIntegerType}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssumeRoleResponse(
    credentials: Optional[zio.aws.sts.model.Credentials] = Optional.Absent,
    assumedRoleUser: Optional[zio.aws.sts.model.AssumedRoleUser] =
      Optional.Absent,
    packedPolicySize: Optional[NonNegativeIntegerType] = Optional.Absent,
    sourceIdentity: Optional[SourceIdentityType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.AssumeRoleResponse = {
    import AssumeRoleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.AssumeRoleResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .optionallyWith(assumedRoleUser.map(value => value.buildAwsValue()))(
        _.assumedRoleUser
      )
      .optionallyWith(
        packedPolicySize.map(value =>
          NonNegativeIntegerType.unwrap(value): Integer
        )
      )(_.packedPolicySize)
      .optionallyWith(
        sourceIdentity.map(value =>
          SourceIdentityType.unwrap(value): java.lang.String
        )
      )(_.sourceIdentity)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.AssumeRoleResponse.ReadOnly =
    zio.aws.sts.model.AssumeRoleResponse.wrap(buildAwsValue())
}
object AssumeRoleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.AssumeRoleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.AssumeRoleResponse =
      zio.aws.sts.model.AssumeRoleResponse(
        credentials.map(value => value.asEditable),
        assumedRoleUser.map(value => value.asEditable),
        packedPolicySize.map(value => value),
        sourceIdentity.map(value => value)
      )
    def credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly]
    def assumedRoleUser: Optional[zio.aws.sts.model.AssumedRoleUser.ReadOnly]
    def packedPolicySize: Optional[NonNegativeIntegerType]
    def sourceIdentity: Optional[SourceIdentityType]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.sts.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getAssumedRoleUser
        : ZIO[Any, AwsError, zio.aws.sts.model.AssumedRoleUser.ReadOnly] =
      AwsError.unwrapOptionField("assumedRoleUser", assumedRoleUser)
    def getPackedPolicySize: ZIO[Any, AwsError, NonNegativeIntegerType] =
      AwsError.unwrapOptionField("packedPolicySize", packedPolicySize)
    def getSourceIdentity: ZIO[Any, AwsError, SourceIdentityType] =
      AwsError.unwrapOptionField("sourceIdentity", sourceIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleResponse
  ) extends zio.aws.sts.model.AssumeRoleResponse.ReadOnly {
    override val credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.sts.model.Credentials.wrap(value))
    override val assumedRoleUser
        : Optional[zio.aws.sts.model.AssumedRoleUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assumedRoleUser())
        .map(value => zio.aws.sts.model.AssumedRoleUser.wrap(value))
    override val packedPolicySize: Optional[NonNegativeIntegerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packedPolicySize())
        .map(value =>
          zio.aws.sts.model.primitives.NonNegativeIntegerType(value)
        )
    override val sourceIdentity: Optional[SourceIdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceIdentity())
        .map(value => zio.aws.sts.model.primitives.SourceIdentityType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleResponse
  ): zio.aws.sts.model.AssumeRoleResponse.ReadOnly = new Wrapper(impl)
}
