package zio.aws.sts.model
import zio.aws.sts.model.primitives.{ArnType, AssumedRoleIdType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssumedRoleUser(
    assumedRoleId: AssumedRoleIdType,
    arn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.AssumedRoleUser = {
    import AssumedRoleUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.AssumedRoleUser
      .builder()
      .assumedRoleId(AssumedRoleIdType.unwrap(assumedRoleId): java.lang.String)
      .arn(ArnType.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.AssumedRoleUser.ReadOnly =
    zio.aws.sts.model.AssumedRoleUser.wrap(buildAwsValue())
}
object AssumedRoleUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.AssumedRoleUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.AssumedRoleUser =
      zio.aws.sts.model.AssumedRoleUser(assumedRoleId, arn)
    def assumedRoleId: AssumedRoleIdType
    def arn: ArnType
    def getAssumedRoleId: ZIO[Any, Nothing, AssumedRoleIdType] =
      ZIO.succeed(assumedRoleId)
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.AssumedRoleUser
  ) extends zio.aws.sts.model.AssumedRoleUser.ReadOnly {
    override val assumedRoleId: AssumedRoleIdType =
      zio.aws.sts.model.primitives.AssumedRoleIdType(impl.assumedRoleId())
    override val arn: ArnType = zio.aws.sts.model.primitives.ArnType(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.AssumedRoleUser
  ): zio.aws.sts.model.AssumedRoleUser.ReadOnly = new Wrapper(impl)
}
