package zio.aws.sts.model
import zio.aws.sts.model.primitives.AccountType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccessKeyInfoResponse(
    account: Optional[AccountType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.GetAccessKeyInfoResponse = {
    import GetAccessKeyInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.GetAccessKeyInfoResponse
      .builder()
      .optionallyWith(
        account.map(value => AccountType.unwrap(value): java.lang.String)
      )(_.account)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.GetAccessKeyInfoResponse.ReadOnly =
    zio.aws.sts.model.GetAccessKeyInfoResponse.wrap(buildAwsValue())
}
object GetAccessKeyInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.GetAccessKeyInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.GetAccessKeyInfoResponse =
      zio.aws.sts.model.GetAccessKeyInfoResponse(account.map(value => value))
    def account: Optional[AccountType]
    def getAccount: ZIO[Any, AwsError, AccountType] =
      AwsError.unwrapOptionField("account", account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.GetAccessKeyInfoResponse
  ) extends zio.aws.sts.model.GetAccessKeyInfoResponse.ReadOnly {
    override val account: Optional[AccountType] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.sts.model.primitives.AccountType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.GetAccessKeyInfoResponse
  ): zio.aws.sts.model.GetAccessKeyInfoResponse.ReadOnly = new Wrapper(impl)
}
