package zio.aws.sts.model
import zio.aws.sts.model.primitives.{ArnType, AccountType, UserIdType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCallerIdentityResponse(
    userId: Optional[UserIdType] = Optional.Absent,
    account: Optional[AccountType] = Optional.Absent,
    arn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse = {
    import GetCallerIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse
      .builder()
      .optionallyWith(
        userId.map(value => UserIdType.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        account.map(value => AccountType.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.GetCallerIdentityResponse.ReadOnly =
    zio.aws.sts.model.GetCallerIdentityResponse.wrap(buildAwsValue())
}
object GetCallerIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.GetCallerIdentityResponse =
      zio.aws.sts.model.GetCallerIdentityResponse(
        userId.map(value => value),
        account.map(value => value),
        arn.map(value => value)
      )
    def userId: Optional[UserIdType]
    def account: Optional[AccountType]
    def arn: Optional[ArnType]
    def getUserId: ZIO[Any, AwsError, UserIdType] =
      AwsError.unwrapOptionField("userId", userId)
    def getAccount: ZIO[Any, AwsError, AccountType] =
      AwsError.unwrapOptionField("account", account)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse
  ) extends zio.aws.sts.model.GetCallerIdentityResponse.ReadOnly {
    override val userId: Optional[UserIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.sts.model.primitives.UserIdType(value))
    override val account: Optional[AccountType] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.sts.model.primitives.AccountType(value))
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.sts.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse
  ): zio.aws.sts.model.GetCallerIdentityResponse.ReadOnly = new Wrapper(impl)
}
