package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.NonNegativeIntegerType
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetFederationTokenResponse(
    credentials: Optional[zio.aws.sts.model.Credentials] = Optional.Absent,
    federatedUser: Optional[zio.aws.sts.model.FederatedUser] = Optional.Absent,
    packedPolicySize: Optional[NonNegativeIntegerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.GetFederationTokenResponse = {
    import GetFederationTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.GetFederationTokenResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .optionallyWith(federatedUser.map(value => value.buildAwsValue()))(
        _.federatedUser
      )
      .optionallyWith(
        packedPolicySize.map(value =>
          NonNegativeIntegerType.unwrap(value): Integer
        )
      )(_.packedPolicySize)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.GetFederationTokenResponse.ReadOnly =
    zio.aws.sts.model.GetFederationTokenResponse.wrap(buildAwsValue())
}
object GetFederationTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.GetFederationTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.GetFederationTokenResponse =
      zio.aws.sts.model.GetFederationTokenResponse(
        credentials.map(value => value.asEditable),
        federatedUser.map(value => value.asEditable),
        packedPolicySize.map(value => value)
      )
    def credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly]
    def federatedUser: Optional[zio.aws.sts.model.FederatedUser.ReadOnly]
    def packedPolicySize: Optional[NonNegativeIntegerType]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.sts.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getFederatedUser
        : ZIO[Any, AwsError, zio.aws.sts.model.FederatedUser.ReadOnly] =
      AwsError.unwrapOptionField("federatedUser", federatedUser)
    def getPackedPolicySize: ZIO[Any, AwsError, NonNegativeIntegerType] =
      AwsError.unwrapOptionField("packedPolicySize", packedPolicySize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.GetFederationTokenResponse
  ) extends zio.aws.sts.model.GetFederationTokenResponse.ReadOnly {
    override val credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.sts.model.Credentials.wrap(value))
    override val federatedUser
        : Optional[zio.aws.sts.model.FederatedUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.federatedUser())
        .map(value => zio.aws.sts.model.FederatedUser.wrap(value))
    override val packedPolicySize: Optional[NonNegativeIntegerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packedPolicySize())
        .map(value =>
          zio.aws.sts.model.primitives.NonNegativeIntegerType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.GetFederationTokenResponse
  ): zio.aws.sts.model.GetFederationTokenResponse.ReadOnly = new Wrapper(impl)
}
