package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.{
  TokenCodeType,
  SerialNumberType,
  DurationSecondsType
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetSessionTokenRequest(
    durationSeconds: Optional[DurationSecondsType] = Optional.Absent,
    serialNumber: Optional[SerialNumberType] = Optional.Absent,
    tokenCode: Optional[TokenCodeType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.GetSessionTokenRequest = {
    import GetSessionTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.GetSessionTokenRequest
      .builder()
      .optionallyWith(
        durationSeconds.map(value => DurationSecondsType.unwrap(value): Integer)
      )(_.durationSeconds)
      .optionallyWith(
        serialNumber.map(value =>
          SerialNumberType.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(
        tokenCode.map(value => TokenCodeType.unwrap(value): java.lang.String)
      )(_.tokenCode)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.GetSessionTokenRequest.ReadOnly =
    zio.aws.sts.model.GetSessionTokenRequest.wrap(buildAwsValue())
}
object GetSessionTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.GetSessionTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.GetSessionTokenRequest =
      zio.aws.sts.model.GetSessionTokenRequest(
        durationSeconds.map(value => value),
        serialNumber.map(value => value),
        tokenCode.map(value => value)
      )
    def durationSeconds: Optional[DurationSecondsType]
    def serialNumber: Optional[SerialNumberType]
    def tokenCode: Optional[TokenCodeType]
    def getDurationSeconds: ZIO[Any, AwsError, DurationSecondsType] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getSerialNumber: ZIO[Any, AwsError, SerialNumberType] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getTokenCode: ZIO[Any, AwsError, TokenCodeType] =
      AwsError.unwrapOptionField("tokenCode", tokenCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.GetSessionTokenRequest
  ) extends zio.aws.sts.model.GetSessionTokenRequest.ReadOnly {
    override val durationSeconds: Optional[DurationSecondsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value => zio.aws.sts.model.primitives.DurationSecondsType(value))
    override val serialNumber: Optional[SerialNumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serialNumber())
        .map(value => zio.aws.sts.model.primitives.SerialNumberType(value))
    override val tokenCode: Optional[TokenCodeType] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenCode())
      .map(value => zio.aws.sts.model.primitives.TokenCodeType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.GetSessionTokenRequest
  ): zio.aws.sts.model.GetSessionTokenRequest.ReadOnly = new Wrapper(impl)
}
