package zio.aws.sts.model
import zio.aws.sts.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PolicyDescriptorType(
    arn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.PolicyDescriptorType = {
    import PolicyDescriptorType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.PolicyDescriptorType
      .builder()
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.PolicyDescriptorType.ReadOnly =
    zio.aws.sts.model.PolicyDescriptorType.wrap(buildAwsValue())
}
object PolicyDescriptorType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.PolicyDescriptorType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.PolicyDescriptorType =
      zio.aws.sts.model.PolicyDescriptorType(arn.map(value => value))
    def arn: Optional[ArnType]
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.PolicyDescriptorType
  ) extends zio.aws.sts.model.PolicyDescriptorType.ReadOnly {
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.sts.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.PolicyDescriptorType
  ): zio.aws.sts.model.PolicyDescriptorType.ReadOnly = new Wrapper(impl)
}
