package zio.aws.sts
import zio.aws.sts.model.AssumeRoleResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.sts.{
  StsAsyncClientBuilder,
  StsAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.sts.model.{
  GetAccessKeyInfoRequest,
  AssumeRoleRequest,
  DecodeAuthorizationMessageRequest,
  GetFederationTokenRequest,
  AssumeRoleWithSamlRequest,
  GetCallerIdentityRequest,
  AssumeRoleWithWebIdentityRequest,
  GetSessionTokenRequest
}
import software.amazon.awssdk.services.sts.model.{
  GetAccessKeyInfoResponse,
  GetSessionTokenResponse,
  AssumeRoleWithSamlResponse,
  GetCallerIdentityResponse,
  AssumeRoleResponse,
  AssumeRoleWithWebIdentityResponse,
  GetFederationTokenResponse,
  DecodeAuthorizationMessageResponse
}
import scala.jdk.CollectionConverters.*
trait Sts extends AspectSupport[Sts] {
  val api: StsAsyncClient
  def assumeRole(request: AssumeRoleRequest): IO[AwsError, ReadOnly]
  def getCallerIdentity(
      request: GetCallerIdentityRequest
  ): IO[AwsError, zio.aws.sts.model.GetCallerIdentityResponse.ReadOnly]
  def assumeRoleWithWebIdentity(
      request: AssumeRoleWithWebIdentityRequest
  ): IO[AwsError, zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.ReadOnly]
  def getSessionToken(
      request: GetSessionTokenRequest
  ): IO[AwsError, zio.aws.sts.model.GetSessionTokenResponse.ReadOnly]
  def getFederationToken(
      request: GetFederationTokenRequest
  ): IO[AwsError, zio.aws.sts.model.GetFederationTokenResponse.ReadOnly]
  def decodeAuthorizationMessage(
      request: DecodeAuthorizationMessageRequest
  ): IO[AwsError, zio.aws.sts.model.DecodeAuthorizationMessageResponse.ReadOnly]
  def getAccessKeyInfo(
      request: GetAccessKeyInfoRequest
  ): IO[AwsError, zio.aws.sts.model.GetAccessKeyInfoResponse.ReadOnly]
  def assumeRoleWithSAML(
      request: AssumeRoleWithSamlRequest
  ): IO[AwsError, zio.aws.sts.model.AssumeRoleWithSamlResponse.ReadOnly]
}
object Sts {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Sts] = customized(identity)
  def customized(
      customization: StsAsyncClientBuilder => StsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Sts] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: StsAsyncClientBuilder => StsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Sts] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = StsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[StsAsyncClient, StsAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[StsAsyncClient, StsAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new StsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class StsImpl[R](
      override val api: StsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Sts
      with AwsServiceBase[R] {
    override val serviceName: String = "Sts"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): StsImpl[R1] = new StsImpl(api, newAspect, r)
    def assumeRole(request: AssumeRoleRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sts.model.AssumeRoleRequest,
        AssumeRoleResponse
      ]("assumeRole", api.assumeRole)(request.buildAwsValue())
        .map(zio.aws.sts.model.AssumeRoleResponse.wrap)
        .provideEnvironment(r)
    def getCallerIdentity(
        request: GetCallerIdentityRequest
    ): IO[AwsError, zio.aws.sts.model.GetCallerIdentityResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest,
        GetCallerIdentityResponse
      ]("getCallerIdentity", api.getCallerIdentity)(request.buildAwsValue())
        .map(zio.aws.sts.model.GetCallerIdentityResponse.wrap)
        .provideEnvironment(r)
    def assumeRoleWithWebIdentity(
        request: AssumeRoleWithWebIdentityRequest
    ): IO[
      AwsError,
      zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest,
      AssumeRoleWithWebIdentityResponse
    ]("assumeRoleWithWebIdentity", api.assumeRoleWithWebIdentity)(
      request.buildAwsValue()
    ).map(zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.wrap)
      .provideEnvironment(r)
    def getSessionToken(
        request: GetSessionTokenRequest
    ): IO[AwsError, zio.aws.sts.model.GetSessionTokenResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sts.model.GetSessionTokenRequest,
        GetSessionTokenResponse
      ]("getSessionToken", api.getSessionToken)(request.buildAwsValue())
        .map(zio.aws.sts.model.GetSessionTokenResponse.wrap)
        .provideEnvironment(r)
    def getFederationToken(
        request: GetFederationTokenRequest
    ): IO[AwsError, zio.aws.sts.model.GetFederationTokenResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sts.model.GetFederationTokenRequest,
        GetFederationTokenResponse
      ]("getFederationToken", api.getFederationToken)(request.buildAwsValue())
        .map(zio.aws.sts.model.GetFederationTokenResponse.wrap)
        .provideEnvironment(r)
    def decodeAuthorizationMessage(
        request: DecodeAuthorizationMessageRequest
    ): IO[
      AwsError,
      zio.aws.sts.model.DecodeAuthorizationMessageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest,
      DecodeAuthorizationMessageResponse
    ]("decodeAuthorizationMessage", api.decodeAuthorizationMessage)(
      request.buildAwsValue()
    ).map(zio.aws.sts.model.DecodeAuthorizationMessageResponse.wrap)
      .provideEnvironment(r)
    def getAccessKeyInfo(
        request: GetAccessKeyInfoRequest
    ): IO[AwsError, zio.aws.sts.model.GetAccessKeyInfoResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest,
        GetAccessKeyInfoResponse
      ]("getAccessKeyInfo", api.getAccessKeyInfo)(request.buildAwsValue())
        .map(zio.aws.sts.model.GetAccessKeyInfoResponse.wrap)
        .provideEnvironment(r)
    def assumeRoleWithSAML(
        request: AssumeRoleWithSamlRequest
    ): IO[AwsError, zio.aws.sts.model.AssumeRoleWithSamlResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest,
        AssumeRoleWithSamlResponse
      ]("assumeRoleWithSAML", api.assumeRoleWithSAML)(request.buildAwsValue())
        .map(zio.aws.sts.model.AssumeRoleWithSamlResponse.wrap)
        .provideEnvironment(r)
  }
  def assumeRole(
      request: AssumeRoleRequest
  ): ZIO[zio.aws.sts.Sts, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.assumeRole(request))
  def getCallerIdentity(request: GetCallerIdentityRequest): ZIO[
    zio.aws.sts.Sts,
    AwsError,
    zio.aws.sts.model.GetCallerIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCallerIdentity(request))
  def assumeRoleWithWebIdentity(request: AssumeRoleWithWebIdentityRequest): ZIO[
    zio.aws.sts.Sts,
    AwsError,
    zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assumeRoleWithWebIdentity(request))
  def getSessionToken(request: GetSessionTokenRequest): ZIO[
    zio.aws.sts.Sts,
    AwsError,
    zio.aws.sts.model.GetSessionTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSessionToken(request))
  def getFederationToken(request: GetFederationTokenRequest): ZIO[
    zio.aws.sts.Sts,
    AwsError,
    zio.aws.sts.model.GetFederationTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFederationToken(request))
  def decodeAuthorizationMessage(
      request: DecodeAuthorizationMessageRequest
  ): ZIO[
    zio.aws.sts.Sts,
    AwsError,
    zio.aws.sts.model.DecodeAuthorizationMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.decodeAuthorizationMessage(request))
  def getAccessKeyInfo(request: GetAccessKeyInfoRequest): ZIO[
    zio.aws.sts.Sts,
    AwsError,
    zio.aws.sts.model.GetAccessKeyInfoResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessKeyInfo(request))
  def assumeRoleWithSAML(request: AssumeRoleWithSamlRequest): ZIO[
    zio.aws.sts.Sts,
    AwsError,
    zio.aws.sts.model.AssumeRoleWithSamlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assumeRoleWithSAML(request))
}
