package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.{
  RoleDurationSecondsType,
  SessionPolicyDocumentType,
  SAMLAssertionType,
  ArnType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AssumeRoleWithSamlRequest(
    roleArn: ArnType,
    principalArn: ArnType,
    samlAssertion: SAMLAssertionType,
    policyArns: Optional[Iterable[zio.aws.sts.model.PolicyDescriptorType]] =
      Optional.Absent,
    policy: Optional[SessionPolicyDocumentType] = Optional.Absent,
    durationSeconds: Optional[RoleDurationSecondsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest = {
    import AssumeRoleWithSamlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest
      .builder()
      .roleArn(ArnType.unwrap(roleArn): java.lang.String)
      .principalArn(ArnType.unwrap(principalArn): java.lang.String)
      .samlAssertion(SAMLAssertionType.unwrap(samlAssertion): java.lang.String)
      .optionallyWith(
        policyArns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyArns)
      .optionallyWith(
        policy.map(value =>
          SessionPolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.policy)
      .optionallyWith(
        durationSeconds.map(value =>
          RoleDurationSecondsType.unwrap(value): Integer
        )
      )(_.durationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.AssumeRoleWithSamlRequest.ReadOnly =
    zio.aws.sts.model.AssumeRoleWithSamlRequest.wrap(buildAwsValue())
}
object AssumeRoleWithSamlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.AssumeRoleWithSamlRequest =
      zio.aws.sts.model.AssumeRoleWithSamlRequest(
        roleArn,
        principalArn,
        samlAssertion,
        policyArns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policy.map(value => value),
        durationSeconds.map(value => value)
      )
    def roleArn: ArnType
    def principalArn: ArnType
    def samlAssertion: SAMLAssertionType
    def policyArns
        : Optional[List[zio.aws.sts.model.PolicyDescriptorType.ReadOnly]]
    def policy: Optional[SessionPolicyDocumentType]
    def durationSeconds: Optional[RoleDurationSecondsType]
    def getRoleArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(roleArn)
    def getPrincipalArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(principalArn)
    def getSamlAssertion: ZIO[Any, Nothing, SAMLAssertionType] =
      ZIO.succeed(samlAssertion)
    def getPolicyArns: ZIO[Any, AwsError, List[
      zio.aws.sts.model.PolicyDescriptorType.ReadOnly
    ]] = AwsError.unwrapOptionField("policyArns", policyArns)
    def getPolicy: ZIO[Any, AwsError, SessionPolicyDocumentType] =
      AwsError.unwrapOptionField("policy", policy)
    def getDurationSeconds: ZIO[Any, AwsError, RoleDurationSecondsType] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest
  ) extends zio.aws.sts.model.AssumeRoleWithSamlRequest.ReadOnly {
    override val roleArn: ArnType =
      zio.aws.sts.model.primitives.ArnType(impl.roleArn())
    override val principalArn: ArnType =
      zio.aws.sts.model.primitives.ArnType(impl.principalArn())
    override val samlAssertion: SAMLAssertionType =
      zio.aws.sts.model.primitives.SAMLAssertionType(impl.samlAssertion())
    override val policyArns
        : Optional[List[zio.aws.sts.model.PolicyDescriptorType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sts.model.PolicyDescriptorType.wrap(item)
          }.toList
        )
    override val policy: Optional[SessionPolicyDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value =>
          zio.aws.sts.model.primitives.SessionPolicyDocumentType(value)
        )
    override val durationSeconds: Optional[RoleDurationSecondsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value =>
          zio.aws.sts.model.primitives.RoleDurationSecondsType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest
  ): zio.aws.sts.model.AssumeRoleWithSamlRequest.ReadOnly = new Wrapper(impl)
}
