package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.{
  Issuer,
  SourceIdentityType,
  Audience,
  NameQualifier,
  SubjectType,
  Subject,
  NonNegativeIntegerType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AssumeRoleWithSamlResponse(
    credentials: Optional[zio.aws.sts.model.Credentials] = Optional.Absent,
    assumedRoleUser: Optional[zio.aws.sts.model.AssumedRoleUser] =
      Optional.Absent,
    packedPolicySize: Optional[NonNegativeIntegerType] = Optional.Absent,
    subject: Optional[Subject] = Optional.Absent,
    subjectType: Optional[SubjectType] = Optional.Absent,
    issuer: Optional[Issuer] = Optional.Absent,
    audience: Optional[Audience] = Optional.Absent,
    nameQualifier: Optional[NameQualifier] = Optional.Absent,
    sourceIdentity: Optional[SourceIdentityType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse = {
    import AssumeRoleWithSamlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .optionallyWith(assumedRoleUser.map(value => value.buildAwsValue()))(
        _.assumedRoleUser
      )
      .optionallyWith(
        packedPolicySize.map(value =>
          NonNegativeIntegerType.unwrap(value): Integer
        )
      )(_.packedPolicySize)
      .optionallyWith(
        subject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        subjectType.map(value => SubjectType.unwrap(value): java.lang.String)
      )(_.subjectType)
      .optionallyWith(
        issuer.map(value => Issuer.unwrap(value): java.lang.String)
      )(_.issuer)
      .optionallyWith(
        audience.map(value => Audience.unwrap(value): java.lang.String)
      )(_.audience)
      .optionallyWith(
        nameQualifier.map(value =>
          NameQualifier.unwrap(value): java.lang.String
        )
      )(_.nameQualifier)
      .optionallyWith(
        sourceIdentity.map(value =>
          SourceIdentityType.unwrap(value): java.lang.String
        )
      )(_.sourceIdentity)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.AssumeRoleWithSamlResponse.ReadOnly =
    zio.aws.sts.model.AssumeRoleWithSamlResponse.wrap(buildAwsValue())
}
object AssumeRoleWithSamlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.AssumeRoleWithSamlResponse =
      zio.aws.sts.model.AssumeRoleWithSamlResponse(
        credentials.map(value => value.asEditable),
        assumedRoleUser.map(value => value.asEditable),
        packedPolicySize.map(value => value),
        subject.map(value => value),
        subjectType.map(value => value),
        issuer.map(value => value),
        audience.map(value => value),
        nameQualifier.map(value => value),
        sourceIdentity.map(value => value)
      )
    def credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly]
    def assumedRoleUser: Optional[zio.aws.sts.model.AssumedRoleUser.ReadOnly]
    def packedPolicySize: Optional[NonNegativeIntegerType]
    def subject: Optional[Subject]
    def subjectType: Optional[SubjectType]
    def issuer: Optional[Issuer]
    def audience: Optional[Audience]
    def nameQualifier: Optional[NameQualifier]
    def sourceIdentity: Optional[SourceIdentityType]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.sts.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getAssumedRoleUser
        : ZIO[Any, AwsError, zio.aws.sts.model.AssumedRoleUser.ReadOnly] =
      AwsError.unwrapOptionField("assumedRoleUser", assumedRoleUser)
    def getPackedPolicySize: ZIO[Any, AwsError, NonNegativeIntegerType] =
      AwsError.unwrapOptionField("packedPolicySize", packedPolicySize)
    def getSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("subject", subject)
    def getSubjectType: ZIO[Any, AwsError, SubjectType] =
      AwsError.unwrapOptionField("subjectType", subjectType)
    def getIssuer: ZIO[Any, AwsError, Issuer] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getAudience: ZIO[Any, AwsError, Audience] =
      AwsError.unwrapOptionField("audience", audience)
    def getNameQualifier: ZIO[Any, AwsError, NameQualifier] =
      AwsError.unwrapOptionField("nameQualifier", nameQualifier)
    def getSourceIdentity: ZIO[Any, AwsError, SourceIdentityType] =
      AwsError.unwrapOptionField("sourceIdentity", sourceIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse
  ) extends zio.aws.sts.model.AssumeRoleWithSamlResponse.ReadOnly {
    override val credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.sts.model.Credentials.wrap(value))
    override val assumedRoleUser
        : Optional[zio.aws.sts.model.AssumedRoleUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assumedRoleUser())
        .map(value => zio.aws.sts.model.AssumedRoleUser.wrap(value))
    override val packedPolicySize: Optional[NonNegativeIntegerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packedPolicySize())
        .map(value =>
          zio.aws.sts.model.primitives.NonNegativeIntegerType(value)
        )
    override val subject: Optional[Subject] = zio.aws.core.internal
      .optionalFromNullable(impl.subject())
      .map(value => zio.aws.sts.model.primitives.Subject(value))
    override val subjectType: Optional[SubjectType] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectType())
      .map(value => zio.aws.sts.model.primitives.SubjectType(value))
    override val issuer: Optional[Issuer] = zio.aws.core.internal
      .optionalFromNullable(impl.issuer())
      .map(value => zio.aws.sts.model.primitives.Issuer(value))
    override val audience: Optional[Audience] = zio.aws.core.internal
      .optionalFromNullable(impl.audience())
      .map(value => zio.aws.sts.model.primitives.Audience(value))
    override val nameQualifier: Optional[NameQualifier] = zio.aws.core.internal
      .optionalFromNullable(impl.nameQualifier())
      .map(value => zio.aws.sts.model.primitives.NameQualifier(value))
    override val sourceIdentity: Optional[SourceIdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceIdentity())
        .map(value => zio.aws.sts.model.primitives.SourceIdentityType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse
  ): zio.aws.sts.model.AssumeRoleWithSamlResponse.ReadOnly = new Wrapper(impl)
}
