package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.{
  ArnType,
  UrlType,
  SessionPolicyDocumentType,
  ClientTokenType,
  RoleSessionNameType,
  RoleDurationSecondsType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AssumeRoleWithWebIdentityRequest(
    roleArn: ArnType,
    roleSessionName: RoleSessionNameType,
    webIdentityToken: ClientTokenType,
    providerId: Optional[UrlType] = Optional.Absent,
    policyArns: Optional[Iterable[zio.aws.sts.model.PolicyDescriptorType]] =
      Optional.Absent,
    policy: Optional[SessionPolicyDocumentType] = Optional.Absent,
    durationSeconds: Optional[RoleDurationSecondsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest = {
    import AssumeRoleWithWebIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest
      .builder()
      .roleArn(ArnType.unwrap(roleArn): java.lang.String)
      .roleSessionName(
        RoleSessionNameType.unwrap(roleSessionName): java.lang.String
      )
      .webIdentityToken(
        ClientTokenType.unwrap(webIdentityToken): java.lang.String
      )
      .optionallyWith(
        providerId.map(value => UrlType.unwrap(value): java.lang.String)
      )(_.providerId)
      .optionallyWith(
        policyArns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyArns)
      .optionallyWith(
        policy.map(value =>
          SessionPolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.policy)
      .optionallyWith(
        durationSeconds.map(value =>
          RoleDurationSecondsType.unwrap(value): Integer
        )
      )(_.durationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.AssumeRoleWithWebIdentityRequest.ReadOnly =
    zio.aws.sts.model.AssumeRoleWithWebIdentityRequest.wrap(buildAwsValue())
}
object AssumeRoleWithWebIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.AssumeRoleWithWebIdentityRequest =
      zio.aws.sts.model.AssumeRoleWithWebIdentityRequest(
        roleArn,
        roleSessionName,
        webIdentityToken,
        providerId.map(value => value),
        policyArns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policy.map(value => value),
        durationSeconds.map(value => value)
      )
    def roleArn: ArnType
    def roleSessionName: RoleSessionNameType
    def webIdentityToken: ClientTokenType
    def providerId: Optional[UrlType]
    def policyArns
        : Optional[List[zio.aws.sts.model.PolicyDescriptorType.ReadOnly]]
    def policy: Optional[SessionPolicyDocumentType]
    def durationSeconds: Optional[RoleDurationSecondsType]
    def getRoleArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(roleArn)
    def getRoleSessionName: ZIO[Any, Nothing, RoleSessionNameType] =
      ZIO.succeed(roleSessionName)
    def getWebIdentityToken: ZIO[Any, Nothing, ClientTokenType] =
      ZIO.succeed(webIdentityToken)
    def getProviderId: ZIO[Any, AwsError, UrlType] =
      AwsError.unwrapOptionField("providerId", providerId)
    def getPolicyArns: ZIO[Any, AwsError, List[
      zio.aws.sts.model.PolicyDescriptorType.ReadOnly
    ]] = AwsError.unwrapOptionField("policyArns", policyArns)
    def getPolicy: ZIO[Any, AwsError, SessionPolicyDocumentType] =
      AwsError.unwrapOptionField("policy", policy)
    def getDurationSeconds: ZIO[Any, AwsError, RoleDurationSecondsType] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest
  ) extends zio.aws.sts.model.AssumeRoleWithWebIdentityRequest.ReadOnly {
    override val roleArn: ArnType =
      zio.aws.sts.model.primitives.ArnType(impl.roleArn())
    override val roleSessionName: RoleSessionNameType =
      zio.aws.sts.model.primitives.RoleSessionNameType(impl.roleSessionName())
    override val webIdentityToken: ClientTokenType =
      zio.aws.sts.model.primitives.ClientTokenType(impl.webIdentityToken())
    override val providerId: Optional[UrlType] = zio.aws.core.internal
      .optionalFromNullable(impl.providerId())
      .map(value => zio.aws.sts.model.primitives.UrlType(value))
    override val policyArns
        : Optional[List[zio.aws.sts.model.PolicyDescriptorType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sts.model.PolicyDescriptorType.wrap(item)
          }.toList
        )
    override val policy: Optional[SessionPolicyDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value =>
          zio.aws.sts.model.primitives.SessionPolicyDocumentType(value)
        )
    override val durationSeconds: Optional[RoleDurationSecondsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value =>
          zio.aws.sts.model.primitives.RoleDurationSecondsType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest
  ): zio.aws.sts.model.AssumeRoleWithWebIdentityRequest.ReadOnly = new Wrapper(
    impl
  )
}
