package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.{
  Issuer,
  SourceIdentityType,
  WebIdentitySubjectType,
  Audience,
  NonNegativeIntegerType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AssumeRoleWithWebIdentityResponse(
    credentials: Optional[zio.aws.sts.model.Credentials] = Optional.Absent,
    subjectFromWebIdentityToken: Optional[WebIdentitySubjectType] =
      Optional.Absent,
    assumedRoleUser: Optional[zio.aws.sts.model.AssumedRoleUser] =
      Optional.Absent,
    packedPolicySize: Optional[NonNegativeIntegerType] = Optional.Absent,
    provider: Optional[Issuer] = Optional.Absent,
    audience: Optional[Audience] = Optional.Absent,
    sourceIdentity: Optional[SourceIdentityType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse = {
    import AssumeRoleWithWebIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .optionallyWith(
        subjectFromWebIdentityToken.map(value =>
          WebIdentitySubjectType.unwrap(value): java.lang.String
        )
      )(_.subjectFromWebIdentityToken)
      .optionallyWith(assumedRoleUser.map(value => value.buildAwsValue()))(
        _.assumedRoleUser
      )
      .optionallyWith(
        packedPolicySize.map(value =>
          NonNegativeIntegerType.unwrap(value): Integer
        )
      )(_.packedPolicySize)
      .optionallyWith(
        provider.map(value => Issuer.unwrap(value): java.lang.String)
      )(_.provider)
      .optionallyWith(
        audience.map(value => Audience.unwrap(value): java.lang.String)
      )(_.audience)
      .optionallyWith(
        sourceIdentity.map(value =>
          SourceIdentityType.unwrap(value): java.lang.String
        )
      )(_.sourceIdentity)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.ReadOnly =
    zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.wrap(buildAwsValue())
}
object AssumeRoleWithWebIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.AssumeRoleWithWebIdentityResponse =
      zio.aws.sts.model.AssumeRoleWithWebIdentityResponse(
        credentials.map(value => value.asEditable),
        subjectFromWebIdentityToken.map(value => value),
        assumedRoleUser.map(value => value.asEditable),
        packedPolicySize.map(value => value),
        provider.map(value => value),
        audience.map(value => value),
        sourceIdentity.map(value => value)
      )
    def credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly]
    def subjectFromWebIdentityToken: Optional[WebIdentitySubjectType]
    def assumedRoleUser: Optional[zio.aws.sts.model.AssumedRoleUser.ReadOnly]
    def packedPolicySize: Optional[NonNegativeIntegerType]
    def provider: Optional[Issuer]
    def audience: Optional[Audience]
    def sourceIdentity: Optional[SourceIdentityType]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.sts.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getSubjectFromWebIdentityToken
        : ZIO[Any, AwsError, WebIdentitySubjectType] =
      AwsError.unwrapOptionField(
        "subjectFromWebIdentityToken",
        subjectFromWebIdentityToken
      )
    def getAssumedRoleUser
        : ZIO[Any, AwsError, zio.aws.sts.model.AssumedRoleUser.ReadOnly] =
      AwsError.unwrapOptionField("assumedRoleUser", assumedRoleUser)
    def getPackedPolicySize: ZIO[Any, AwsError, NonNegativeIntegerType] =
      AwsError.unwrapOptionField("packedPolicySize", packedPolicySize)
    def getProvider: ZIO[Any, AwsError, Issuer] =
      AwsError.unwrapOptionField("provider", provider)
    def getAudience: ZIO[Any, AwsError, Audience] =
      AwsError.unwrapOptionField("audience", audience)
    def getSourceIdentity: ZIO[Any, AwsError, SourceIdentityType] =
      AwsError.unwrapOptionField("sourceIdentity", sourceIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse
  ) extends zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.ReadOnly {
    override val credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.sts.model.Credentials.wrap(value))
    override val subjectFromWebIdentityToken: Optional[WebIdentitySubjectType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subjectFromWebIdentityToken())
        .map(value =>
          zio.aws.sts.model.primitives.WebIdentitySubjectType(value)
        )
    override val assumedRoleUser
        : Optional[zio.aws.sts.model.AssumedRoleUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assumedRoleUser())
        .map(value => zio.aws.sts.model.AssumedRoleUser.wrap(value))
    override val packedPolicySize: Optional[NonNegativeIntegerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packedPolicySize())
        .map(value =>
          zio.aws.sts.model.primitives.NonNegativeIntegerType(value)
        )
    override val provider: Optional[Issuer] = zio.aws.core.internal
      .optionalFromNullable(impl.provider())
      .map(value => zio.aws.sts.model.primitives.Issuer(value))
    override val audience: Optional[Audience] = zio.aws.core.internal
      .optionalFromNullable(impl.audience())
      .map(value => zio.aws.sts.model.primitives.Audience(value))
    override val sourceIdentity: Optional[SourceIdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceIdentity())
        .map(value => zio.aws.sts.model.primitives.SourceIdentityType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse
  ): zio.aws.sts.model.AssumeRoleWithWebIdentityResponse.ReadOnly = new Wrapper(
    impl
  )
}
