package zio.aws.sts.model
import zio.aws.sts.model.primitives.EncodedMessageType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DecodeAuthorizationMessageRequest(
    encodedMessage: EncodedMessageType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest = {
    import DecodeAuthorizationMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest
      .builder()
      .encodedMessage(
        EncodedMessageType.unwrap(encodedMessage): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sts.model.DecodeAuthorizationMessageRequest.ReadOnly =
    zio.aws.sts.model.DecodeAuthorizationMessageRequest.wrap(buildAwsValue())
}
object DecodeAuthorizationMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.DecodeAuthorizationMessageRequest =
      zio.aws.sts.model.DecodeAuthorizationMessageRequest(encodedMessage)
    def encodedMessage: EncodedMessageType
    def getEncodedMessage: ZIO[Any, Nothing, EncodedMessageType] =
      ZIO.succeed(encodedMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest
  ) extends zio.aws.sts.model.DecodeAuthorizationMessageRequest.ReadOnly {
    override val encodedMessage: EncodedMessageType =
      zio.aws.sts.model.primitives.EncodedMessageType(impl.encodedMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest
  ): zio.aws.sts.model.DecodeAuthorizationMessageRequest.ReadOnly = new Wrapper(
    impl
  )
}
