package zio.aws.sts.model
import zio.aws.sts.model.primitives.DecodedMessageType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DecodeAuthorizationMessageResponse(
    decodedMessage: Optional[DecodedMessageType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse = {
    import DecodeAuthorizationMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse
      .builder()
      .optionallyWith(
        decodedMessage.map(value =>
          DecodedMessageType.unwrap(value): java.lang.String
        )
      )(_.decodedMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.sts.model.DecodeAuthorizationMessageResponse.ReadOnly =
    zio.aws.sts.model.DecodeAuthorizationMessageResponse.wrap(buildAwsValue())
}
object DecodeAuthorizationMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.DecodeAuthorizationMessageResponse =
      zio.aws.sts.model
        .DecodeAuthorizationMessageResponse(decodedMessage.map(value => value))
    def decodedMessage: Optional[DecodedMessageType]
    def getDecodedMessage: ZIO[Any, AwsError, DecodedMessageType] =
      AwsError.unwrapOptionField("decodedMessage", decodedMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse
  ) extends zio.aws.sts.model.DecodeAuthorizationMessageResponse.ReadOnly {
    override val decodedMessage: Optional[DecodedMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.decodedMessage())
        .map(value => zio.aws.sts.model.primitives.DecodedMessageType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse
  ): zio.aws.sts.model.DecodeAuthorizationMessageResponse.ReadOnly =
    new Wrapper(impl)
}
