package zio.aws.sts.model
import zio.aws.sts.model.primitives.{ArnType, FederatedIdType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FederatedUser(federatedUserId: FederatedIdType, arn: ArnType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.FederatedUser = {
    import FederatedUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.FederatedUser
      .builder()
      .federatedUserId(
        FederatedIdType.unwrap(federatedUserId): java.lang.String
      )
      .arn(ArnType.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.FederatedUser.ReadOnly =
    zio.aws.sts.model.FederatedUser.wrap(buildAwsValue())
}
object FederatedUser {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sts.model.FederatedUser] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.FederatedUser =
      zio.aws.sts.model.FederatedUser(federatedUserId, arn)
    def federatedUserId: FederatedIdType
    def arn: ArnType
    def getFederatedUserId: ZIO[Any, Nothing, FederatedIdType] =
      ZIO.succeed(federatedUserId)
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.FederatedUser
  ) extends zio.aws.sts.model.FederatedUser.ReadOnly {
    override val federatedUserId: FederatedIdType =
      zio.aws.sts.model.primitives.FederatedIdType(impl.federatedUserId())
    override val arn: ArnType = zio.aws.sts.model.primitives.ArnType(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.FederatedUser
  ): zio.aws.sts.model.FederatedUser.ReadOnly = new Wrapper(impl)
}
