package zio.aws.sts.model
import zio.aws.sts.model.primitives.AccessKeyIdType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAccessKeyInfoRequest(accessKeyId: AccessKeyIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest = {
    import GetAccessKeyInfoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest
      .builder()
      .accessKeyId(AccessKeyIdType.unwrap(accessKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.GetAccessKeyInfoRequest.ReadOnly =
    zio.aws.sts.model.GetAccessKeyInfoRequest.wrap(buildAwsValue())
}
object GetAccessKeyInfoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.GetAccessKeyInfoRequest =
      zio.aws.sts.model.GetAccessKeyInfoRequest(accessKeyId)
    def accessKeyId: AccessKeyIdType
    def getAccessKeyId: ZIO[Any, Nothing, AccessKeyIdType] =
      ZIO.succeed(accessKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest
  ) extends zio.aws.sts.model.GetAccessKeyInfoRequest.ReadOnly {
    override val accessKeyId: AccessKeyIdType =
      zio.aws.sts.model.primitives.AccessKeyIdType(impl.accessKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.GetAccessKeyInfoRequest
  ): zio.aws.sts.model.GetAccessKeyInfoRequest.ReadOnly = new Wrapper(impl)
}
