package zio.aws.sts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sts.model.primitives.{
  DurationSecondsType,
  SessionPolicyDocumentType,
  UserNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetFederationTokenRequest(
    name: UserNameType,
    policy: Optional[SessionPolicyDocumentType] = Optional.Absent,
    policyArns: Optional[Iterable[zio.aws.sts.model.PolicyDescriptorType]] =
      Optional.Absent,
    durationSeconds: Optional[DurationSecondsType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sts.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.GetFederationTokenRequest = {
    import GetFederationTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.GetFederationTokenRequest
      .builder()
      .name(UserNameType.unwrap(name): java.lang.String)
      .optionallyWith(
        policy.map(value =>
          SessionPolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.policy)
      .optionallyWith(
        policyArns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyArns)
      .optionallyWith(
        durationSeconds.map(value => DurationSecondsType.unwrap(value): Integer)
      )(_.durationSeconds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.GetFederationTokenRequest.ReadOnly =
    zio.aws.sts.model.GetFederationTokenRequest.wrap(buildAwsValue())
}
object GetFederationTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.GetFederationTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.GetFederationTokenRequest =
      zio.aws.sts.model.GetFederationTokenRequest(
        name,
        policy.map(value => value),
        policyArns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        durationSeconds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: UserNameType
    def policy: Optional[SessionPolicyDocumentType]
    def policyArns
        : Optional[List[zio.aws.sts.model.PolicyDescriptorType.ReadOnly]]
    def durationSeconds: Optional[DurationSecondsType]
    def tags: Optional[List[zio.aws.sts.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(name)
    def getPolicy: ZIO[Any, AwsError, SessionPolicyDocumentType] =
      AwsError.unwrapOptionField("policy", policy)
    def getPolicyArns: ZIO[Any, AwsError, List[
      zio.aws.sts.model.PolicyDescriptorType.ReadOnly
    ]] = AwsError.unwrapOptionField("policyArns", policyArns)
    def getDurationSeconds: ZIO[Any, AwsError, DurationSecondsType] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sts.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.GetFederationTokenRequest
  ) extends zio.aws.sts.model.GetFederationTokenRequest.ReadOnly {
    override val name: UserNameType =
      zio.aws.sts.model.primitives.UserNameType(impl.name())
    override val policy: Optional[SessionPolicyDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value =>
          zio.aws.sts.model.primitives.SessionPolicyDocumentType(value)
        )
    override val policyArns
        : Optional[List[zio.aws.sts.model.PolicyDescriptorType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sts.model.PolicyDescriptorType.wrap(item)
          }.toList
        )
    override val durationSeconds: Optional[DurationSecondsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value => zio.aws.sts.model.primitives.DurationSecondsType(value))
    override val tags: Optional[List[zio.aws.sts.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sts.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.GetFederationTokenRequest
  ): zio.aws.sts.model.GetFederationTokenRequest.ReadOnly = new Wrapper(impl)
}
