package zio.aws.sts.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSessionTokenResponse(
    credentials: Optional[zio.aws.sts.model.Credentials] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sts.model.GetSessionTokenResponse = {
    import GetSessionTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.GetSessionTokenResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .build()
  }
  def asReadOnly: zio.aws.sts.model.GetSessionTokenResponse.ReadOnly =
    zio.aws.sts.model.GetSessionTokenResponse.wrap(buildAwsValue())
}
object GetSessionTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sts.model.GetSessionTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.GetSessionTokenResponse =
      zio.aws.sts.model
        .GetSessionTokenResponse(credentials.map(value => value.asEditable))
    def credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.sts.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.GetSessionTokenResponse
  ) extends zio.aws.sts.model.GetSessionTokenResponse.ReadOnly {
    override val credentials: Optional[zio.aws.sts.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.sts.model.Credentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.GetSessionTokenResponse
  ): zio.aws.sts.model.GetSessionTokenResponse.ReadOnly = new Wrapper(impl)
}
