package zio.aws.sts.model
import zio.aws.sts.model.primitives.{TagValueType, TagKeyType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Tag(key: TagKeyType, value: TagValueType) {
  def buildAwsValue(): software.amazon.awssdk.services.sts.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sts.model.Tag
      .builder()
      .key(TagKeyType.unwrap(key): java.lang.String)
      .value(TagValueType.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sts.model.Tag.ReadOnly =
    zio.aws.sts.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sts.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sts.model.Tag = zio.aws.sts.model.Tag(key, value)
    def key: TagKeyType
    def value: TagValueType
    def getKey: ZIO[Any, Nothing, TagKeyType] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValueType] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sts.model.Tag
  ) extends zio.aws.sts.model.Tag.ReadOnly {
    override val key: TagKeyType =
      zio.aws.sts.model.primitives.TagKeyType(impl.key())
    override val value: TagValueType =
      zio.aws.sts.model.primitives.TagValueType(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sts.model.Tag
  ): zio.aws.sts.model.Tag.ReadOnly = new Wrapper(impl)
}
