package zio.aws.synthetics
import zio.aws.synthetics.model.Canary.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.synthetics.{
  SyntheticsAsyncClientBuilder,
  SyntheticsAsyncClient
}
import zio.aws.synthetics.model.{
  StopCanaryRequest,
  UpdateCanaryRequest,
  StartCanaryRequest,
  ListTagsForResourceRequest,
  DescribeCanariesLastRunRequest,
  DescribeCanariesRequest,
  GetCanaryRequest,
  DeleteCanaryRequest,
  GetCanaryRunsRequest,
  CreateCanaryRequest,
  DescribeRuntimeVersionsRequest,
  UntagResourceRequest,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.synthetics.model.{
  DescribeRuntimeVersionsResponse,
  StartCanaryResponse,
  GetCanaryRunsResponse,
  CreateCanaryResponse,
  UpdateCanaryResponse,
  CanaryRun,
  CanaryLastRun,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetCanaryResponse,
  DescribeCanariesLastRunResponse,
  StopCanaryResponse,
  Canary,
  DescribeCanariesResponse,
  DeleteCanaryResponse,
  TagResourceResponse,
  RuntimeVersion
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Synthetics extends AspectSupport[Synthetics] {
  val api: SyntheticsAsyncClient
  def startCanary(
      request: StartCanaryRequest
  ): IO[AwsError, zio.aws.synthetics.model.StartCanaryResponse.ReadOnly]
  def getCanary(
      request: GetCanaryRequest
  ): IO[AwsError, zio.aws.synthetics.model.GetCanaryResponse.ReadOnly]
  def describeRuntimeVersions(
      request: DescribeRuntimeVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.synthetics.model.RuntimeVersion.ReadOnly]
  def describeRuntimeVersionsPaginated(
      request: DescribeRuntimeVersionsRequest
  ): IO[
    AwsError,
    zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.ReadOnly
  ]
  def describeCanariesLastRun(
      request: DescribeCanariesLastRunRequest
  ): ZStream[Any, AwsError, zio.aws.synthetics.model.CanaryLastRun.ReadOnly]
  def describeCanariesLastRunPaginated(
      request: DescribeCanariesLastRunRequest
  ): IO[
    AwsError,
    zio.aws.synthetics.model.DescribeCanariesLastRunResponse.ReadOnly
  ]
  def getCanaryRuns(
      request: GetCanaryRunsRequest
  ): ZStream[Any, AwsError, zio.aws.synthetics.model.CanaryRun.ReadOnly]
  def getCanaryRunsPaginated(
      request: GetCanaryRunsRequest
  ): IO[AwsError, zio.aws.synthetics.model.GetCanaryRunsResponse.ReadOnly]
  def createCanary(
      request: CreateCanaryRequest
  ): IO[AwsError, zio.aws.synthetics.model.CreateCanaryResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.synthetics.model.UntagResourceResponse.ReadOnly]
  def stopCanary(
      request: StopCanaryRequest
  ): IO[AwsError, zio.aws.synthetics.model.StopCanaryResponse.ReadOnly]
  def describeCanaries(
      request: DescribeCanariesRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def describeCanariesPaginated(
      request: DescribeCanariesRequest
  ): IO[AwsError, zio.aws.synthetics.model.DescribeCanariesResponse.ReadOnly]
  def deleteCanary(
      request: DeleteCanaryRequest
  ): IO[AwsError, zio.aws.synthetics.model.DeleteCanaryResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.synthetics.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.synthetics.model.TagResourceResponse.ReadOnly]
  def updateCanary(
      request: UpdateCanaryRequest
  ): IO[AwsError, zio.aws.synthetics.model.UpdateCanaryResponse.ReadOnly]
}
object Synthetics {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Synthetics] = customized(
    identity
  )
  def customized(
      customization: SyntheticsAsyncClientBuilder => SyntheticsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Synthetics] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SyntheticsAsyncClientBuilder => SyntheticsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Synthetics] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SyntheticsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SyntheticsAsyncClient, SyntheticsAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[SyntheticsAsyncClient, SyntheticsAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SyntheticsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SyntheticsImpl[R](
      override val api: SyntheticsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Synthetics
      with AwsServiceBase[R] {
    override val serviceName: String = "Synthetics"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SyntheticsImpl[R1] = new SyntheticsImpl(api, newAspect, r)
    def startCanary(
        request: StartCanaryRequest
    ): IO[AwsError, zio.aws.synthetics.model.StartCanaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.StartCanaryRequest,
        StartCanaryResponse
      ]("startCanary", api.startCanary)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.StartCanaryResponse.wrap)
        .provideEnvironment(r)
    def getCanary(
        request: GetCanaryRequest
    ): IO[AwsError, zio.aws.synthetics.model.GetCanaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.GetCanaryRequest,
        GetCanaryResponse
      ]("getCanary", api.getCanary)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.GetCanaryResponse.wrap)
        .provideEnvironment(r)
    def describeRuntimeVersions(
        request: DescribeRuntimeVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.synthetics.model.RuntimeVersion.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest,
      DescribeRuntimeVersionsResponse,
      RuntimeVersion
    ](
      "describeRuntimeVersions",
      api.describeRuntimeVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.runtimeVersions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.synthetics.model.RuntimeVersion.wrap(item))
      .provideEnvironment(r)
    def describeRuntimeVersionsPaginated(
        request: DescribeRuntimeVersionsRequest
    ): IO[
      AwsError,
      zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.synthetics.model.DescribeRuntimeVersionsRequest,
      DescribeRuntimeVersionsResponse
    ]("describeRuntimeVersions", api.describeRuntimeVersions)(
      request.buildAwsValue()
    ).map(zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.wrap)
      .provideEnvironment(r)
    def describeCanariesLastRun(
        request: DescribeCanariesLastRunRequest
    ): ZStream[Any, AwsError, zio.aws.synthetics.model.CanaryLastRun.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest,
        DescribeCanariesLastRunResponse,
        CanaryLastRun
      ](
        "describeCanariesLastRun",
        api.describeCanariesLastRun,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.canariesLastRun().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.synthetics.model.CanaryLastRun.wrap(item))
        .provideEnvironment(r)
    def describeCanariesLastRunPaginated(
        request: DescribeCanariesLastRunRequest
    ): IO[
      AwsError,
      zio.aws.synthetics.model.DescribeCanariesLastRunResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.synthetics.model.DescribeCanariesLastRunRequest,
      DescribeCanariesLastRunResponse
    ]("describeCanariesLastRun", api.describeCanariesLastRun)(
      request.buildAwsValue()
    ).map(zio.aws.synthetics.model.DescribeCanariesLastRunResponse.wrap)
      .provideEnvironment(r)
    def getCanaryRuns(
        request: GetCanaryRunsRequest
    ): ZStream[Any, AwsError, zio.aws.synthetics.model.CanaryRun.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest,
        GetCanaryRunsResponse,
        CanaryRun
      ](
        "getCanaryRuns",
        api.getCanaryRuns,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.canaryRuns().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.synthetics.model.CanaryRun.wrap(item))
        .provideEnvironment(r)
    def getCanaryRunsPaginated(
        request: GetCanaryRunsRequest
    ): IO[AwsError, zio.aws.synthetics.model.GetCanaryRunsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest,
        GetCanaryRunsResponse
      ]("getCanaryRuns", api.getCanaryRuns)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.GetCanaryRunsResponse.wrap)
        .provideEnvironment(r)
    def createCanary(
        request: CreateCanaryRequest
    ): IO[AwsError, zio.aws.synthetics.model.CreateCanaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.CreateCanaryRequest,
        CreateCanaryResponse
      ]("createCanary", api.createCanary)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.CreateCanaryResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.synthetics.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def stopCanary(
        request: StopCanaryRequest
    ): IO[AwsError, zio.aws.synthetics.model.StopCanaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.StopCanaryRequest,
        StopCanaryResponse
      ]("stopCanary", api.stopCanary)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.StopCanaryResponse.wrap)
        .provideEnvironment(r)
    def describeCanaries(
        request: DescribeCanariesRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest,
      DescribeCanariesResponse,
      Canary
    ](
      "describeCanaries",
      api.describeCanaries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.canaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.synthetics.model.Canary.wrap(item))
      .provideEnvironment(r)
    def describeCanariesPaginated(request: DescribeCanariesRequest): IO[
      AwsError,
      zio.aws.synthetics.model.DescribeCanariesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest,
      DescribeCanariesResponse
    ]("describeCanaries", api.describeCanaries)(request.buildAwsValue())
      .map(zio.aws.synthetics.model.DescribeCanariesResponse.wrap)
      .provideEnvironment(r)
    def deleteCanary(
        request: DeleteCanaryRequest
    ): IO[AwsError, zio.aws.synthetics.model.DeleteCanaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.DeleteCanaryRequest,
        DeleteCanaryResponse
      ]("deleteCanary", api.deleteCanary)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.DeleteCanaryResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.synthetics.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.synthetics.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.synthetics.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.synthetics.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateCanary(
        request: UpdateCanaryRequest
    ): IO[AwsError, zio.aws.synthetics.model.UpdateCanaryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.synthetics.model.UpdateCanaryRequest,
        UpdateCanaryResponse
      ]("updateCanary", api.updateCanary)(request.buildAwsValue())
        .map(zio.aws.synthetics.model.UpdateCanaryResponse.wrap)
        .provideEnvironment(r)
  }
  def startCanary(request: StartCanaryRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.StartCanaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startCanary(request))
  def getCanary(request: GetCanaryRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.GetCanaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCanary(request))
  def describeRuntimeVersions(request: DescribeRuntimeVersionsRequest): ZStream[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.RuntimeVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.describeRuntimeVersions(request))
  def describeRuntimeVersionsPaginated(
      request: DescribeRuntimeVersionsRequest
  ): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRuntimeVersionsPaginated(request))
  def describeCanariesLastRun(request: DescribeCanariesLastRunRequest): ZStream[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.CanaryLastRun.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCanariesLastRun(request))
  def describeCanariesLastRunPaginated(
      request: DescribeCanariesLastRunRequest
  ): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.DescribeCanariesLastRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCanariesLastRunPaginated(request))
  def getCanaryRuns(request: GetCanaryRunsRequest): ZStream[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.CanaryRun.ReadOnly
  ] = ZStream.serviceWithStream(_.getCanaryRuns(request))
  def getCanaryRunsPaginated(request: GetCanaryRunsRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.GetCanaryRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCanaryRunsPaginated(request))
  def createCanary(request: CreateCanaryRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.CreateCanaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCanary(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def stopCanary(request: StopCanaryRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.StopCanaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopCanary(request))
  def describeCanaries(
      request: DescribeCanariesRequest
  ): ZStream[zio.aws.synthetics.Synthetics, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.describeCanaries(request))
  def describeCanariesPaginated(request: DescribeCanariesRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.DescribeCanariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCanariesPaginated(request))
  def deleteCanary(request: DeleteCanaryRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.DeleteCanaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCanary(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateCanary(request: UpdateCanaryRequest): ZIO[
    zio.aws.synthetics.Synthetics,
    AwsError,
    zio.aws.synthetics.model.UpdateCanaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCanary(request))
}
