package zio.aws.synthetics
import zio.aws.synthetics.model.Canary.ReadOnly
import software.amazon.awssdk.services.synthetics.SyntheticsAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.synthetics.model.{
  StopCanaryRequest,
  UpdateCanaryRequest,
  StartCanaryRequest,
  ListTagsForResourceRequest,
  DescribeCanariesLastRunRequest,
  DescribeCanariesRequest,
  GetCanaryRequest,
  DeleteCanaryRequest,
  GetCanaryRunsRequest,
  CreateCanaryRequest,
  DescribeRuntimeVersionsRequest,
  UntagResourceRequest,
  TagResourceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object SyntheticsMock extends Mock[Synthetics] {
  object StartCanary
      extends Effect[
        StartCanaryRequest,
        AwsError,
        zio.aws.synthetics.model.StartCanaryResponse.ReadOnly
      ]
  object GetCanary
      extends Effect[
        GetCanaryRequest,
        AwsError,
        zio.aws.synthetics.model.GetCanaryResponse.ReadOnly
      ]
  object DescribeRuntimeVersions
      extends Stream[
        DescribeRuntimeVersionsRequest,
        AwsError,
        zio.aws.synthetics.model.RuntimeVersion.ReadOnly
      ]
  object DescribeRuntimeVersionsPaginated
      extends Effect[
        DescribeRuntimeVersionsRequest,
        AwsError,
        zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.ReadOnly
      ]
  object DescribeCanariesLastRun
      extends Stream[
        DescribeCanariesLastRunRequest,
        AwsError,
        zio.aws.synthetics.model.CanaryLastRun.ReadOnly
      ]
  object DescribeCanariesLastRunPaginated
      extends Effect[
        DescribeCanariesLastRunRequest,
        AwsError,
        zio.aws.synthetics.model.DescribeCanariesLastRunResponse.ReadOnly
      ]
  object GetCanaryRuns
      extends Stream[
        GetCanaryRunsRequest,
        AwsError,
        zio.aws.synthetics.model.CanaryRun.ReadOnly
      ]
  object GetCanaryRunsPaginated
      extends Effect[
        GetCanaryRunsRequest,
        AwsError,
        zio.aws.synthetics.model.GetCanaryRunsResponse.ReadOnly
      ]
  object CreateCanary
      extends Effect[
        CreateCanaryRequest,
        AwsError,
        zio.aws.synthetics.model.CreateCanaryResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.synthetics.model.UntagResourceResponse.ReadOnly
      ]
  object StopCanary
      extends Effect[
        StopCanaryRequest,
        AwsError,
        zio.aws.synthetics.model.StopCanaryResponse.ReadOnly
      ]
  object DescribeCanaries
      extends Stream[DescribeCanariesRequest, AwsError, ReadOnly]
  object DescribeCanariesPaginated
      extends Effect[
        DescribeCanariesRequest,
        AwsError,
        zio.aws.synthetics.model.DescribeCanariesResponse.ReadOnly
      ]
  object DeleteCanary
      extends Effect[
        DeleteCanaryRequest,
        AwsError,
        zio.aws.synthetics.model.DeleteCanaryResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.synthetics.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.synthetics.model.TagResourceResponse.ReadOnly
      ]
  object UpdateCanary
      extends Effect[
        UpdateCanaryRequest,
        AwsError,
        zio.aws.synthetics.model.UpdateCanaryResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Synthetics] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Synthetics] { rts =>
        zio.ZIO.succeed {
          new Synthetics {
            val api: SyntheticsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Synthetics = this
            def startCanary(request: StartCanaryRequest): IO[
              AwsError,
              zio.aws.synthetics.model.StartCanaryResponse.ReadOnly
            ] = proxy(StartCanary, request)
            def getCanary(request: GetCanaryRequest): IO[
              AwsError,
              zio.aws.synthetics.model.GetCanaryResponse.ReadOnly
            ] = proxy(GetCanary, request)
            def describeRuntimeVersions(
                request: DescribeRuntimeVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.synthetics.model.RuntimeVersion.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeRuntimeVersions, request))
            def describeRuntimeVersionsPaginated(
                request: DescribeRuntimeVersionsRequest
            ): IO[
              AwsError,
              zio.aws.synthetics.model.DescribeRuntimeVersionsResponse.ReadOnly
            ] = proxy(DescribeRuntimeVersionsPaginated, request)
            def describeCanariesLastRun(
                request: DescribeCanariesLastRunRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.synthetics.model.CanaryLastRun.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeCanariesLastRun, request))
            def describeCanariesLastRunPaginated(
                request: DescribeCanariesLastRunRequest
            ): IO[
              AwsError,
              zio.aws.synthetics.model.DescribeCanariesLastRunResponse.ReadOnly
            ] = proxy(DescribeCanariesLastRunPaginated, request)
            def getCanaryRuns(request: GetCanaryRunsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.synthetics.model.CanaryRun.ReadOnly
            ] = rts.unsafeRun(proxy(GetCanaryRuns, request))
            def getCanaryRunsPaginated(request: GetCanaryRunsRequest): IO[
              AwsError,
              zio.aws.synthetics.model.GetCanaryRunsResponse.ReadOnly
            ] = proxy(GetCanaryRunsPaginated, request)
            def createCanary(request: CreateCanaryRequest): IO[
              AwsError,
              zio.aws.synthetics.model.CreateCanaryResponse.ReadOnly
            ] = proxy(CreateCanary, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.synthetics.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def stopCanary(request: StopCanaryRequest): IO[
              AwsError,
              zio.aws.synthetics.model.StopCanaryResponse.ReadOnly
            ] = proxy(StopCanary, request)
            def describeCanaries(
                request: DescribeCanariesRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              rts.unsafeRun(proxy(DescribeCanaries, request))
            def describeCanariesPaginated(request: DescribeCanariesRequest): IO[
              AwsError,
              zio.aws.synthetics.model.DescribeCanariesResponse.ReadOnly
            ] = proxy(DescribeCanariesPaginated, request)
            def deleteCanary(request: DeleteCanaryRequest): IO[
              AwsError,
              zio.aws.synthetics.model.DeleteCanaryResponse.ReadOnly
            ] = proxy(DeleteCanary, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.synthetics.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.synthetics.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateCanary(request: UpdateCanaryRequest): IO[
              AwsError,
              zio.aws.synthetics.model.UpdateCanaryResponse.ReadOnly
            ] = proxy(UpdateCanary, request)
          }
        }
      }
    }
  }
}
