package zio.aws.synthetics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ArtifactConfigInput(
    s3Encryption: Optional[zio.aws.synthetics.model.S3EncryptionConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.ArtifactConfigInput = {
    import ArtifactConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.ArtifactConfigInput
      .builder()
      .optionallyWith(s3Encryption.map(value => value.buildAwsValue()))(
        _.s3Encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly =
    zio.aws.synthetics.model.ArtifactConfigInput.wrap(buildAwsValue())
}
object ArtifactConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.ArtifactConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.ArtifactConfigInput =
      zio.aws.synthetics.model
        .ArtifactConfigInput(s3Encryption.map(value => value.asEditable))
    def s3Encryption
        : Optional[zio.aws.synthetics.model.S3EncryptionConfig.ReadOnly]
    def getS3Encryption: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.S3EncryptionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3Encryption", s3Encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.ArtifactConfigInput
  ) extends zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly {
    override val s3Encryption
        : Optional[zio.aws.synthetics.model.S3EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Encryption())
        .map(value => zio.aws.synthetics.model.S3EncryptionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.ArtifactConfigInput
  ): zio.aws.synthetics.model.ArtifactConfigInput.ReadOnly = new Wrapper(impl)
}
