package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.BaseScreenshotConfigIgnoreCoordinate
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BaseScreenshot(
    screenshotName: String,
    ignoreCoordinates: Optional[
      Iterable[BaseScreenshotConfigIgnoreCoordinate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.BaseScreenshot = {
    import BaseScreenshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.BaseScreenshot
      .builder()
      .screenshotName(screenshotName: java.lang.String)
      .optionallyWith(
        ignoreCoordinates.map(value =>
          value.map { item =>
            BaseScreenshotConfigIgnoreCoordinate.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ignoreCoordinates)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.BaseScreenshot.ReadOnly =
    zio.aws.synthetics.model.BaseScreenshot.wrap(buildAwsValue())
}
object BaseScreenshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.BaseScreenshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.BaseScreenshot =
      zio.aws.synthetics.model
        .BaseScreenshot(screenshotName, ignoreCoordinates.map(value => value))
    def screenshotName: String
    def ignoreCoordinates: Optional[List[BaseScreenshotConfigIgnoreCoordinate]]
    def getScreenshotName: ZIO[Any, Nothing, String] =
      ZIO.succeed(screenshotName)
    def getIgnoreCoordinates
        : ZIO[Any, AwsError, List[BaseScreenshotConfigIgnoreCoordinate]] =
      AwsError.unwrapOptionField("ignoreCoordinates", ignoreCoordinates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.BaseScreenshot
  ) extends zio.aws.synthetics.model.BaseScreenshot.ReadOnly {
    override val screenshotName: String = impl.screenshotName(): String
    override val ignoreCoordinates
        : Optional[List[BaseScreenshotConfigIgnoreCoordinate]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ignoreCoordinates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.synthetics.model.primitives
              .BaseScreenshotConfigIgnoreCoordinate(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.BaseScreenshot
  ): zio.aws.synthetics.model.BaseScreenshot.ReadOnly = new Wrapper(impl)
}
