package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{
  RoleArn,
  CanaryName,
  TagValue,
  MaxSize1024,
  FunctionArn,
  UUID,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Canary(
    id: Optional[UUID] = Optional.Absent,
    name: Optional[CanaryName] = Optional.Absent,
    code: Optional[zio.aws.synthetics.model.CanaryCodeOutput] = Optional.Absent,
    executionRoleArn: Optional[RoleArn] = Optional.Absent,
    schedule: Optional[zio.aws.synthetics.model.CanaryScheduleOutput] =
      Optional.Absent,
    runConfig: Optional[zio.aws.synthetics.model.CanaryRunConfigOutput] =
      Optional.Absent,
    successRetentionPeriodInDays: Optional[MaxSize1024] = Optional.Absent,
    failureRetentionPeriodInDays: Optional[MaxSize1024] = Optional.Absent,
    status: Optional[zio.aws.synthetics.model.CanaryStatus] = Optional.Absent,
    timeline: Optional[zio.aws.synthetics.model.CanaryTimeline] =
      Optional.Absent,
    artifactS3Location: Optional[String] = Optional.Absent,
    engineArn: Optional[FunctionArn] = Optional.Absent,
    runtimeVersion: Optional[String] = Optional.Absent,
    vpcConfig: Optional[zio.aws.synthetics.model.VpcConfigOutput] =
      Optional.Absent,
    visualReference: Optional[zio.aws.synthetics.model.VisualReferenceOutput] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    artifactConfig: Optional[zio.aws.synthetics.model.ArtifactConfigOutput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.Canary = {
    import Canary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.Canary
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => CanaryName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(code.map(value => value.buildAwsValue()))(_.code)
      .optionallyWith(
        executionRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(runConfig.map(value => value.buildAwsValue()))(
        _.runConfig
      )
      .optionallyWith(
        successRetentionPeriodInDays.map(value =>
          MaxSize1024.unwrap(value): Integer
        )
      )(_.successRetentionPeriodInDays)
      .optionallyWith(
        failureRetentionPeriodInDays.map(value =>
          MaxSize1024.unwrap(value): Integer
        )
      )(_.failureRetentionPeriodInDays)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .optionallyWith(artifactS3Location.map(value => value: java.lang.String))(
        _.artifactS3Location
      )
      .optionallyWith(
        engineArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.engineArn)
      .optionallyWith(runtimeVersion.map(value => value: java.lang.String))(
        _.runtimeVersion
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(visualReference.map(value => value.buildAwsValue()))(
        _.visualReference
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(artifactConfig.map(value => value.buildAwsValue()))(
        _.artifactConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.Canary.ReadOnly =
    zio.aws.synthetics.model.Canary.wrap(buildAwsValue())
}
object Canary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.synthetics.model.Canary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.Canary =
      zio.aws.synthetics.model.Canary(
        id.map(value => value),
        name.map(value => value),
        code.map(value => value.asEditable),
        executionRoleArn.map(value => value),
        schedule.map(value => value.asEditable),
        runConfig.map(value => value.asEditable),
        successRetentionPeriodInDays.map(value => value),
        failureRetentionPeriodInDays.map(value => value),
        status.map(value => value.asEditable),
        timeline.map(value => value.asEditable),
        artifactS3Location.map(value => value),
        engineArn.map(value => value),
        runtimeVersion.map(value => value),
        vpcConfig.map(value => value.asEditable),
        visualReference.map(value => value.asEditable),
        tags.map(value => value),
        artifactConfig.map(value => value.asEditable)
      )
    def id: Optional[UUID]
    def name: Optional[CanaryName]
    def code: Optional[zio.aws.synthetics.model.CanaryCodeOutput.ReadOnly]
    def executionRoleArn: Optional[RoleArn]
    def schedule
        : Optional[zio.aws.synthetics.model.CanaryScheduleOutput.ReadOnly]
    def runConfig
        : Optional[zio.aws.synthetics.model.CanaryRunConfigOutput.ReadOnly]
    def successRetentionPeriodInDays: Optional[MaxSize1024]
    def failureRetentionPeriodInDays: Optional[MaxSize1024]
    def status: Optional[zio.aws.synthetics.model.CanaryStatus.ReadOnly]
    def timeline: Optional[zio.aws.synthetics.model.CanaryTimeline.ReadOnly]
    def artifactS3Location: Optional[String]
    def engineArn: Optional[FunctionArn]
    def runtimeVersion: Optional[String]
    def vpcConfig: Optional[zio.aws.synthetics.model.VpcConfigOutput.ReadOnly]
    def visualReference
        : Optional[zio.aws.synthetics.model.VisualReferenceOutput.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def artifactConfig
        : Optional[zio.aws.synthetics.model.ArtifactConfigOutput.ReadOnly]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, CanaryName] =
      AwsError.unwrapOptionField("name", name)
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryCodeOutput.ReadOnly
    ] = AwsError.unwrapOptionField("code", code)
    def getExecutionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryScheduleOutput.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getRunConfig: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryRunConfigOutput.ReadOnly
    ] = AwsError.unwrapOptionField("runConfig", runConfig)
    def getSuccessRetentionPeriodInDays: ZIO[Any, AwsError, MaxSize1024] =
      AwsError.unwrapOptionField(
        "successRetentionPeriodInDays",
        successRetentionPeriodInDays
      )
    def getFailureRetentionPeriodInDays: ZIO[Any, AwsError, MaxSize1024] =
      AwsError.unwrapOptionField(
        "failureRetentionPeriodInDays",
        failureRetentionPeriodInDays
      )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.synthetics.model.CanaryStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getTimeline
        : ZIO[Any, AwsError, zio.aws.synthetics.model.CanaryTimeline.ReadOnly] =
      AwsError.unwrapOptionField("timeline", timeline)
    def getArtifactS3Location: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("artifactS3Location", artifactS3Location)
    def getEngineArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("engineArn", engineArn)
    def getRuntimeVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtimeVersion", runtimeVersion)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.VpcConfigOutput.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getVisualReference: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.VisualReferenceOutput.ReadOnly
    ] = AwsError.unwrapOptionField("visualReference", visualReference)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getArtifactConfig: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.ArtifactConfigOutput.ReadOnly
    ] = AwsError.unwrapOptionField("artifactConfig", artifactConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.Canary
  ) extends zio.aws.synthetics.model.Canary.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.synthetics.model.primitives.UUID(value))
    override val name: Optional[CanaryName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.synthetics.model.primitives.CanaryName(value))
    override val code
        : Optional[zio.aws.synthetics.model.CanaryCodeOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.synthetics.model.CanaryCodeOutput.wrap(value))
    override val executionRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => zio.aws.synthetics.model.primitives.RoleArn(value))
    override val schedule
        : Optional[zio.aws.synthetics.model.CanaryScheduleOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.synthetics.model.CanaryScheduleOutput.wrap(value))
    override val runConfig
        : Optional[zio.aws.synthetics.model.CanaryRunConfigOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runConfig())
        .map(value =>
          zio.aws.synthetics.model.CanaryRunConfigOutput.wrap(value)
        )
    override val successRetentionPeriodInDays: Optional[MaxSize1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successRetentionPeriodInDays())
        .map(value => zio.aws.synthetics.model.primitives.MaxSize1024(value))
    override val failureRetentionPeriodInDays: Optional[MaxSize1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureRetentionPeriodInDays())
        .map(value => zio.aws.synthetics.model.primitives.MaxSize1024(value))
    override val status
        : Optional[zio.aws.synthetics.model.CanaryStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.synthetics.model.CanaryStatus.wrap(value))
    override val timeline
        : Optional[zio.aws.synthetics.model.CanaryTimeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeline())
        .map(value => zio.aws.synthetics.model.CanaryTimeline.wrap(value))
    override val artifactS3Location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactS3Location())
      .map(value => value: String)
    override val engineArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.engineArn())
      .map(value => zio.aws.synthetics.model.primitives.FunctionArn(value))
    override val runtimeVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeVersion())
      .map(value => value: String)
    override val vpcConfig
        : Optional[zio.aws.synthetics.model.VpcConfigOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.synthetics.model.VpcConfigOutput.wrap(value))
    override val visualReference
        : Optional[zio.aws.synthetics.model.VisualReferenceOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visualReference())
        .map(value =>
          zio.aws.synthetics.model.VisualReferenceOutput.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.synthetics.model.primitives.TagKey(
              key
            ) -> zio.aws.synthetics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val artifactConfig
        : Optional[zio.aws.synthetics.model.ArtifactConfigOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactConfig())
        .map(value => zio.aws.synthetics.model.ArtifactConfigOutput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.Canary
  ): zio.aws.synthetics.model.Canary.ReadOnly = new Wrapper(impl)
}
