package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.{CodeHandler, Blob}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanaryCodeInput(
    s3Bucket: Optional[String] = Optional.Absent,
    s3Key: Optional[String] = Optional.Absent,
    s3Version: Optional[String] = Optional.Absent,
    zipFile: Optional[Blob] = Optional.Absent,
    handler: CodeHandler
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryCodeInput = {
    import CanaryCodeInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryCodeInput
      .builder()
      .optionallyWith(s3Bucket.map(value => value: java.lang.String))(
        _.s3Bucket
      )
      .optionallyWith(s3Key.map(value => value: java.lang.String))(_.s3Key)
      .optionallyWith(s3Version.map(value => value: java.lang.String))(
        _.s3Version
      )
      .optionallyWith(
        zipFile.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.zipFile)
      .handler(CodeHandler.unwrap(handler): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryCodeInput.ReadOnly =
    zio.aws.synthetics.model.CanaryCodeInput.wrap(buildAwsValue())
}
object CanaryCodeInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryCodeInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryCodeInput =
      zio.aws.synthetics.model.CanaryCodeInput(
        s3Bucket.map(value => value),
        s3Key.map(value => value),
        s3Version.map(value => value),
        zipFile.map(value => value),
        handler
      )
    def s3Bucket: Optional[String]
    def s3Key: Optional[String]
    def s3Version: Optional[String]
    def zipFile: Optional[Blob]
    def handler: CodeHandler
    def getS3Bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getS3Version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Version", s3Version)
    def getZipFile: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("zipFile", zipFile)
    def getHandler: ZIO[Any, Nothing, CodeHandler] = ZIO.succeed(handler)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryCodeInput
  ) extends zio.aws.synthetics.model.CanaryCodeInput.ReadOnly {
    override val s3Bucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => value: String)
    override val s3Key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => value: String)
    override val s3Version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Version())
      .map(value => value: String)
    override val zipFile: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.zipFile())
      .map(value =>
        zio.aws.synthetics.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val handler: CodeHandler =
      zio.aws.synthetics.model.primitives.CodeHandler(impl.handler())
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryCodeInput
  ): zio.aws.synthetics.model.CanaryCodeInput.ReadOnly = new Wrapper(impl)
}
