package zio.aws.synthetics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanaryCodeOutput(
    sourceLocationArn: Optional[String] = Optional.Absent,
    handler: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryCodeOutput = {
    import CanaryCodeOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryCodeOutput
      .builder()
      .optionallyWith(sourceLocationArn.map(value => value: java.lang.String))(
        _.sourceLocationArn
      )
      .optionallyWith(handler.map(value => value: java.lang.String))(_.handler)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryCodeOutput.ReadOnly =
    zio.aws.synthetics.model.CanaryCodeOutput.wrap(buildAwsValue())
}
object CanaryCodeOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryCodeOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryCodeOutput =
      zio.aws.synthetics.model.CanaryCodeOutput(
        sourceLocationArn.map(value => value),
        handler.map(value => value)
      )
    def sourceLocationArn: Optional[String]
    def handler: Optional[String]
    def getSourceLocationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceLocationArn", sourceLocationArn)
    def getHandler: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("handler", handler)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryCodeOutput
  ) extends zio.aws.synthetics.model.CanaryCodeOutput.ReadOnly {
    override val sourceLocationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceLocationArn())
      .map(value => value: String)
    override val handler: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.handler())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryCodeOutput
  ): zio.aws.synthetics.model.CanaryCodeOutput.ReadOnly = new Wrapper(impl)
}
