package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.CanaryName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanaryLastRun(
    canaryName: Optional[CanaryName] = Optional.Absent,
    lastRun: Optional[zio.aws.synthetics.model.CanaryRun] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryLastRun = {
    import CanaryLastRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryLastRun
      .builder()
      .optionallyWith(
        canaryName.map(value => CanaryName.unwrap(value): java.lang.String)
      )(_.canaryName)
      .optionallyWith(lastRun.map(value => value.buildAwsValue()))(_.lastRun)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryLastRun.ReadOnly =
    zio.aws.synthetics.model.CanaryLastRun.wrap(buildAwsValue())
}
object CanaryLastRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryLastRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryLastRun =
      zio.aws.synthetics.model.CanaryLastRun(
        canaryName.map(value => value),
        lastRun.map(value => value.asEditable)
      )
    def canaryName: Optional[CanaryName]
    def lastRun: Optional[zio.aws.synthetics.model.CanaryRun.ReadOnly]
    def getCanaryName: ZIO[Any, AwsError, CanaryName] =
      AwsError.unwrapOptionField("canaryName", canaryName)
    def getLastRun
        : ZIO[Any, AwsError, zio.aws.synthetics.model.CanaryRun.ReadOnly] =
      AwsError.unwrapOptionField("lastRun", lastRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryLastRun
  ) extends zio.aws.synthetics.model.CanaryLastRun.ReadOnly {
    override val canaryName: Optional[CanaryName] = zio.aws.core.internal
      .optionalFromNullable(impl.canaryName())
      .map(value => zio.aws.synthetics.model.primitives.CanaryName(value))
    override val lastRun
        : Optional[zio.aws.synthetics.model.CanaryRun.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRun())
        .map(value => zio.aws.synthetics.model.CanaryRun.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryLastRun
  ): zio.aws.synthetics.model.CanaryLastRun.ReadOnly = new Wrapper(impl)
}
