package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.{CanaryName, UUID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanaryRun(
    id: Optional[UUID] = Optional.Absent,
    name: Optional[CanaryName] = Optional.Absent,
    status: Optional[zio.aws.synthetics.model.CanaryRunStatus] =
      Optional.Absent,
    timeline: Optional[zio.aws.synthetics.model.CanaryRunTimeline] =
      Optional.Absent,
    artifactS3Location: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryRun = {
    import CanaryRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryRun
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => CanaryName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(timeline.map(value => value.buildAwsValue()))(_.timeline)
      .optionallyWith(artifactS3Location.map(value => value: java.lang.String))(
        _.artifactS3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryRun.ReadOnly =
    zio.aws.synthetics.model.CanaryRun.wrap(buildAwsValue())
}
object CanaryRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryRun =
      zio.aws.synthetics.model.CanaryRun(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value.asEditable),
        timeline.map(value => value.asEditable),
        artifactS3Location.map(value => value)
      )
    def id: Optional[UUID]
    def name: Optional[CanaryName]
    def status: Optional[zio.aws.synthetics.model.CanaryRunStatus.ReadOnly]
    def timeline: Optional[zio.aws.synthetics.model.CanaryRunTimeline.ReadOnly]
    def artifactS3Location: Optional[String]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, CanaryName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryRunStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getTimeline: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryRunTimeline.ReadOnly
    ] = AwsError.unwrapOptionField("timeline", timeline)
    def getArtifactS3Location: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("artifactS3Location", artifactS3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRun
  ) extends zio.aws.synthetics.model.CanaryRun.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.synthetics.model.primitives.UUID(value))
    override val name: Optional[CanaryName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.synthetics.model.primitives.CanaryName(value))
    override val status
        : Optional[zio.aws.synthetics.model.CanaryRunStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.synthetics.model.CanaryRunStatus.wrap(value))
    override val timeline
        : Optional[zio.aws.synthetics.model.CanaryRunTimeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeline())
        .map(value => zio.aws.synthetics.model.CanaryRunTimeline.wrap(value))
    override val artifactS3Location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactS3Location())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRun
  ): zio.aws.synthetics.model.CanaryRun.ReadOnly = new Wrapper(impl)
}
