package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{
  MaxFifteenMinutesInSeconds,
  EnvironmentVariableName,
  MaxSize3008,
  EnvironmentVariableValue,
  NullableBoolean
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CanaryRunConfigInput(
    timeoutInSeconds: Optional[MaxFifteenMinutesInSeconds] = Optional.Absent,
    memoryInMB: Optional[MaxSize3008] = Optional.Absent,
    activeTracing: Optional[NullableBoolean] = Optional.Absent,
    environmentVariables: Optional[
      Map[EnvironmentVariableName, EnvironmentVariableValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryRunConfigInput = {
    import CanaryRunConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryRunConfigInput
      .builder()
      .optionallyWith(
        timeoutInSeconds.map(value =>
          MaxFifteenMinutesInSeconds.unwrap(value): Integer
        )
      )(_.timeoutInSeconds)
      .optionallyWith(
        memoryInMB.map(value => MaxSize3008.unwrap(value): Integer)
      )(_.memoryInMB)
      .optionallyWith(activeTracing.map(value => value: java.lang.Boolean))(
        _.activeTracing
      )
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentVariableName
                .unwrap(key): java.lang.String) -> (EnvironmentVariableValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly =
    zio.aws.synthetics.model.CanaryRunConfigInput.wrap(buildAwsValue())
}
object CanaryRunConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryRunConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryRunConfigInput =
      zio.aws.synthetics.model.CanaryRunConfigInput(
        timeoutInSeconds.map(value => value),
        memoryInMB.map(value => value),
        activeTracing.map(value => value),
        environmentVariables.map(value => value)
      )
    def timeoutInSeconds: Optional[MaxFifteenMinutesInSeconds]
    def memoryInMB: Optional[MaxSize3008]
    def activeTracing: Optional[NullableBoolean]
    def environmentVariables
        : Optional[Map[EnvironmentVariableName, EnvironmentVariableValue]]
    def getTimeoutInSeconds: ZIO[Any, AwsError, MaxFifteenMinutesInSeconds] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getMemoryInMB: ZIO[Any, AwsError, MaxSize3008] =
      AwsError.unwrapOptionField("memoryInMB", memoryInMB)
    def getActiveTracing: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("activeTracing", activeTracing)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[
      EnvironmentVariableName,
      EnvironmentVariableValue
    ]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRunConfigInput
  ) extends zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly {
    override val timeoutInSeconds: Optional[MaxFifteenMinutesInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInSeconds())
        .map(value =>
          zio.aws.synthetics.model.primitives.MaxFifteenMinutesInSeconds(value)
        )
    override val memoryInMB: Optional[MaxSize3008] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryInMB())
      .map(value => zio.aws.synthetics.model.primitives.MaxSize3008(value))
    override val activeTracing: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeTracing())
        .map(value => value: NullableBoolean)
    override val environmentVariables
        : Optional[Map[EnvironmentVariableName, EnvironmentVariableValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.synthetics.model.primitives.EnvironmentVariableName(
                key
              ) -> zio.aws.synthetics.model.primitives
                .EnvironmentVariableValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRunConfigInput
  ): zio.aws.synthetics.model.CanaryRunConfigInput.ReadOnly = new Wrapper(impl)
}
