package zio.aws.synthetics.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.{
  NullableBoolean,
  MaxSize3008,
  MaxFifteenMinutesInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CanaryRunConfigOutput(
    timeoutInSeconds: Optional[MaxFifteenMinutesInSeconds] = Optional.Absent,
    memoryInMB: Optional[MaxSize3008] = Optional.Absent,
    activeTracing: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryRunConfigOutput = {
    import CanaryRunConfigOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryRunConfigOutput
      .builder()
      .optionallyWith(
        timeoutInSeconds.map(value =>
          MaxFifteenMinutesInSeconds.unwrap(value): Integer
        )
      )(_.timeoutInSeconds)
      .optionallyWith(
        memoryInMB.map(value => MaxSize3008.unwrap(value): Integer)
      )(_.memoryInMB)
      .optionallyWith(activeTracing.map(value => value: java.lang.Boolean))(
        _.activeTracing
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryRunConfigOutput.ReadOnly =
    zio.aws.synthetics.model.CanaryRunConfigOutput.wrap(buildAwsValue())
}
object CanaryRunConfigOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryRunConfigOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryRunConfigOutput =
      zio.aws.synthetics.model.CanaryRunConfigOutput(
        timeoutInSeconds.map(value => value),
        memoryInMB.map(value => value),
        activeTracing.map(value => value)
      )
    def timeoutInSeconds: Optional[MaxFifteenMinutesInSeconds]
    def memoryInMB: Optional[MaxSize3008]
    def activeTracing: Optional[NullableBoolean]
    def getTimeoutInSeconds: ZIO[Any, AwsError, MaxFifteenMinutesInSeconds] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getMemoryInMB: ZIO[Any, AwsError, MaxSize3008] =
      AwsError.unwrapOptionField("memoryInMB", memoryInMB)
    def getActiveTracing: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("activeTracing", activeTracing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRunConfigOutput
  ) extends zio.aws.synthetics.model.CanaryRunConfigOutput.ReadOnly {
    override val timeoutInSeconds: Optional[MaxFifteenMinutesInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInSeconds())
        .map(value =>
          zio.aws.synthetics.model.primitives.MaxFifteenMinutesInSeconds(value)
        )
    override val memoryInMB: Optional[MaxSize3008] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryInMB())
      .map(value => zio.aws.synthetics.model.primitives.MaxSize3008(value))
    override val activeTracing: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeTracing())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRunConfigOutput
  ): zio.aws.synthetics.model.CanaryRunConfigOutput.ReadOnly = new Wrapper(impl)
}
