package zio.aws.synthetics.model
import scala.jdk.CollectionConverters.*
sealed trait CanaryRunState {
  def unwrap: software.amazon.awssdk.services.synthetics.model.CanaryRunState
}
object CanaryRunState {
  def wrap(
      value: software.amazon.awssdk.services.synthetics.model.CanaryRunState
  ): zio.aws.synthetics.model.CanaryRunState = value match {
    case software.amazon.awssdk.services.synthetics.model.CanaryRunState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryRunState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryRunState.PASSED =>
      val r = PASSED
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryRunState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.synthetics.model.CanaryRunState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryRunState =
      software.amazon.awssdk.services.synthetics.model.CanaryRunState.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.synthetics.model.CanaryRunState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryRunState =
      software.amazon.awssdk.services.synthetics.model.CanaryRunState.RUNNING
  }
  case object PASSED extends zio.aws.synthetics.model.CanaryRunState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryRunState =
      software.amazon.awssdk.services.synthetics.model.CanaryRunState.PASSED
  }
  case object FAILED extends zio.aws.synthetics.model.CanaryRunState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryRunState =
      software.amazon.awssdk.services.synthetics.model.CanaryRunState.FAILED
  }
}
