package zio.aws.synthetics.model
import scala.jdk.CollectionConverters.*
sealed trait CanaryRunStateReasonCode {
  def unwrap: software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode
}
object CanaryRunStateReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode
  ): zio.aws.synthetics.model.CanaryRunStateReasonCode = value match {
    case software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode.CANARY_FAILURE =>
      val r = CANARY_FAILURE
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode.EXECUTION_FAILURE =>
      val r = EXECUTION_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.synthetics.model.CanaryRunStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object CANARY_FAILURE
      extends zio.aws.synthetics.model.CanaryRunStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode.CANARY_FAILURE
  }
  case object EXECUTION_FAILURE
      extends zio.aws.synthetics.model.CanaryRunStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode.EXECUTION_FAILURE
  }
}
