package zio.aws.synthetics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanaryRunStatus(
    state: Optional[zio.aws.synthetics.model.CanaryRunState] = Optional.Absent,
    stateReason: Optional[String] = Optional.Absent,
    stateReasonCode: Optional[
      zio.aws.synthetics.model.CanaryRunStateReasonCode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryRunStatus = {
    import CanaryRunStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryRunStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateReason.map(value => value: java.lang.String))(
        _.stateReason
      )
      .optionallyWith(stateReasonCode.map(value => value.unwrap))(
        _.stateReasonCode
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryRunStatus.ReadOnly =
    zio.aws.synthetics.model.CanaryRunStatus.wrap(buildAwsValue())
}
object CanaryRunStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryRunStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryRunStatus =
      zio.aws.synthetics.model.CanaryRunStatus(
        state.map(value => value),
        stateReason.map(value => value),
        stateReasonCode.map(value => value)
      )
    def state: Optional[zio.aws.synthetics.model.CanaryRunState]
    def stateReason: Optional[String]
    def stateReasonCode
        : Optional[zio.aws.synthetics.model.CanaryRunStateReasonCode]
    def getState: ZIO[Any, AwsError, zio.aws.synthetics.model.CanaryRunState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getStateReasonCode: ZIO[
      Any,
      AwsError,
      zio.aws.synthetics.model.CanaryRunStateReasonCode
    ] = AwsError.unwrapOptionField("stateReasonCode", stateReasonCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRunStatus
  ) extends zio.aws.synthetics.model.CanaryRunStatus.ReadOnly {
    override val state: Optional[zio.aws.synthetics.model.CanaryRunState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.synthetics.model.CanaryRunState.wrap(value))
    override val stateReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReason())
      .map(value => value: String)
    override val stateReasonCode
        : Optional[zio.aws.synthetics.model.CanaryRunStateReasonCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReasonCode())
        .map(value =>
          zio.aws.synthetics.model.CanaryRunStateReasonCode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRunStatus
  ): zio.aws.synthetics.model.CanaryRunStatus.ReadOnly = new Wrapper(impl)
}
