package zio.aws.synthetics.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.synthetics.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class CanaryRunTimeline(
    started: Optional[Timestamp] = Optional.Absent,
    completed: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryRunTimeline = {
    import CanaryRunTimeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryRunTimeline
      .builder()
      .optionallyWith(started.map(value => Timestamp.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(completed.map(value => Timestamp.unwrap(value): Instant))(
        _.completed
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryRunTimeline.ReadOnly =
    zio.aws.synthetics.model.CanaryRunTimeline.wrap(buildAwsValue())
}
object CanaryRunTimeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryRunTimeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryRunTimeline =
      zio.aws.synthetics.model.CanaryRunTimeline(
        started.map(value => value),
        completed.map(value => value)
      )
    def started: Optional[Timestamp]
    def completed: Optional[Timestamp]
    def getStarted: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("started", started)
    def getCompleted: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completed", completed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRunTimeline
  ) extends zio.aws.synthetics.model.CanaryRunTimeline.ReadOnly {
    override val started: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.started())
      .map(value => zio.aws.synthetics.model.primitives.Timestamp(value))
    override val completed: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completed())
      .map(value => zio.aws.synthetics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryRunTimeline
  ): zio.aws.synthetics.model.CanaryRunTimeline.ReadOnly = new Wrapper(impl)
}
