package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.MaxOneYearInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanaryScheduleInput(
    expression: String,
    durationInSeconds: Optional[MaxOneYearInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryScheduleInput = {
    import CanaryScheduleInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryScheduleInput
      .builder()
      .expression(expression: java.lang.String)
      .optionallyWith(
        durationInSeconds.map(value =>
          MaxOneYearInSeconds.unwrap(value): java.lang.Long
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly =
    zio.aws.synthetics.model.CanaryScheduleInput.wrap(buildAwsValue())
}
object CanaryScheduleInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryScheduleInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryScheduleInput =
      zio.aws.synthetics.model
        .CanaryScheduleInput(expression, durationInSeconds.map(value => value))
    def expression: String
    def durationInSeconds: Optional[MaxOneYearInSeconds]
    def getExpression: ZIO[Any, Nothing, String] = ZIO.succeed(expression)
    def getDurationInSeconds: ZIO[Any, AwsError, MaxOneYearInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryScheduleInput
  ) extends zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly {
    override val expression: String = impl.expression(): String
    override val durationInSeconds: Optional[MaxOneYearInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.synthetics.model.primitives.MaxOneYearInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryScheduleInput
  ): zio.aws.synthetics.model.CanaryScheduleInput.ReadOnly = new Wrapper(impl)
}
