package zio.aws.synthetics.model
import zio.aws.synthetics.model.primitives.MaxOneYearInSeconds
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanaryScheduleOutput(
    expression: Optional[String] = Optional.Absent,
    durationInSeconds: Optional[MaxOneYearInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryScheduleOutput = {
    import CanaryScheduleOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryScheduleOutput
      .builder()
      .optionallyWith(expression.map(value => value: java.lang.String))(
        _.expression
      )
      .optionallyWith(
        durationInSeconds.map(value =>
          MaxOneYearInSeconds.unwrap(value): java.lang.Long
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryScheduleOutput.ReadOnly =
    zio.aws.synthetics.model.CanaryScheduleOutput.wrap(buildAwsValue())
}
object CanaryScheduleOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryScheduleOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryScheduleOutput =
      zio.aws.synthetics.model.CanaryScheduleOutput(
        expression.map(value => value),
        durationInSeconds.map(value => value)
      )
    def expression: Optional[String]
    def durationInSeconds: Optional[MaxOneYearInSeconds]
    def getExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expression", expression)
    def getDurationInSeconds: ZIO[Any, AwsError, MaxOneYearInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryScheduleOutput
  ) extends zio.aws.synthetics.model.CanaryScheduleOutput.ReadOnly {
    override val expression: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value => value: String)
    override val durationInSeconds: Optional[MaxOneYearInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.synthetics.model.primitives.MaxOneYearInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryScheduleOutput
  ): zio.aws.synthetics.model.CanaryScheduleOutput.ReadOnly = new Wrapper(impl)
}
