package zio.aws.synthetics.model
import scala.jdk.CollectionConverters.*
sealed trait CanaryState {
  def unwrap: software.amazon.awssdk.services.synthetics.model.CanaryState
}
object CanaryState {
  def wrap(
      value: software.amazon.awssdk.services.synthetics.model.CanaryState
  ): zio.aws.synthetics.model.CanaryState = value match {
    case software.amazon.awssdk.services.synthetics.model.CanaryState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.CREATING
  }
  case object READY extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.READY
  }
  case object STARTING extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.STARTING
  }
  case object RUNNING extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.RUNNING
  }
  case object UPDATING extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.UPDATING
  }
  case object STOPPING extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.STOPPING
  }
  case object STOPPED extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.STOPPED
  }
  case object ERROR extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.ERROR
  }
  case object DELETING extends zio.aws.synthetics.model.CanaryState {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryState =
      software.amazon.awssdk.services.synthetics.model.CanaryState.DELETING
  }
}
