package zio.aws.synthetics.model
import scala.jdk.CollectionConverters.*
sealed trait CanaryStateReasonCode {
  def unwrap
      : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode
}
object CanaryStateReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode
  ): zio.aws.synthetics.model.CanaryStateReasonCode = value match {
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.INVALID_PERMISSIONS =>
      val r = INVALID_PERMISSIONS
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.CREATE_PENDING =>
      val r = CREATE_PENDING
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.UPDATE_PENDING =>
      val r = UPDATE_PENDING
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.UPDATE_COMPLETE =>
      val r = UPDATE_COMPLETE
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.ROLLBACK_COMPLETE =>
      val r = ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.ROLLBACK_FAILED =>
      val r = ROLLBACK_FAILED
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.SYNC_DELETE_IN_PROGRESS =>
      val r = SYNC_DELETE_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INVALID_PERMISSIONS
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.INVALID_PERMISSIONS
  }
  case object CREATE_PENDING
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.CREATE_PENDING
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.CREATE_IN_PROGRESS
  }
  case object CREATE_FAILED
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.CREATE_FAILED
  }
  case object UPDATE_PENDING
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.UPDATE_PENDING
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.UPDATE_IN_PROGRESS
  }
  case object UPDATE_COMPLETE
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.UPDATE_COMPLETE
  }
  case object ROLLBACK_COMPLETE
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.ROLLBACK_COMPLETE
  }
  case object ROLLBACK_FAILED
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.ROLLBACK_FAILED
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.DELETE_FAILED
  }
  case object SYNC_DELETE_IN_PROGRESS
      extends zio.aws.synthetics.model.CanaryStateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode =
      software.amazon.awssdk.services.synthetics.model.CanaryStateReasonCode.SYNC_DELETE_IN_PROGRESS
  }
}
