package zio.aws.synthetics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanaryStatus(
    state: Optional[zio.aws.synthetics.model.CanaryState] = Optional.Absent,
    stateReason: Optional[String] = Optional.Absent,
    stateReasonCode: Optional[zio.aws.synthetics.model.CanaryStateReasonCode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.synthetics.model.CanaryStatus = {
    import CanaryStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.synthetics.model.CanaryStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateReason.map(value => value: java.lang.String))(
        _.stateReason
      )
      .optionallyWith(stateReasonCode.map(value => value.unwrap))(
        _.stateReasonCode
      )
      .build()
  }
  def asReadOnly: zio.aws.synthetics.model.CanaryStatus.ReadOnly =
    zio.aws.synthetics.model.CanaryStatus.wrap(buildAwsValue())
}
object CanaryStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.synthetics.model.CanaryStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.synthetics.model.CanaryStatus =
      zio.aws.synthetics.model.CanaryStatus(
        state.map(value => value),
        stateReason.map(value => value),
        stateReasonCode.map(value => value)
      )
    def state: Optional[zio.aws.synthetics.model.CanaryState]
    def stateReason: Optional[String]
    def stateReasonCode
        : Optional[zio.aws.synthetics.model.CanaryStateReasonCode]
    def getState: ZIO[Any, AwsError, zio.aws.synthetics.model.CanaryState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getStateReasonCode
        : ZIO[Any, AwsError, zio.aws.synthetics.model.CanaryStateReasonCode] =
      AwsError.unwrapOptionField("stateReasonCode", stateReasonCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryStatus
  ) extends zio.aws.synthetics.model.CanaryStatus.ReadOnly {
    override val state: Optional[zio.aws.synthetics.model.CanaryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.synthetics.model.CanaryState.wrap(value))
    override val stateReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReason())
      .map(value => value: String)
    override val stateReasonCode
        : Optional[zio.aws.synthetics.model.CanaryStateReasonCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReasonCode())
        .map(value =>
          zio.aws.synthetics.model.CanaryStateReasonCode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.synthetics.model.CanaryStatus
  ): zio.aws.synthetics.model.CanaryStatus.ReadOnly = new Wrapper(impl)
}
